/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.world.sound;

import io.github.mortuusars.exposure.client.sound.UniqueSoundManager;
import io.github.mortuusars.exposure.network.Packets;
import io.github.mortuusars.exposure.network.packet.clientbound.UniqueSoundPlayS2CP;
import io.github.mortuusars.exposure.network.packet.clientbound.UniqueSoundPlayShutterTickingS2CP;
import io.github.mortuusars.exposure.world.camera.CameraId;
import io.github.mortuusars.exposure.world.sound.SoundEffect;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class Sound {
    public static void play(Level level, double x, double y, double z, SoundEvent sound, SoundSource source) {
        Sound.play(level, x, y, z, sound, source, 1.0f, 1.0f, 0.0f);
    }

    public static void play(Level level, double x, double y, double z, SoundEvent sound, SoundSource source, float volume, float pitch) {
        Sound.play(level, x, y, z, sound, source, volume, pitch, 0.0f);
    }

    public static void play(Level level, double x, double y, double z, SoundEvent sound, SoundSource source, float volume, float pitch, float pitchVariability) {
        pitch = Sound.vary(pitch, pitchVariability);
        level.playSound(null, x, y, z, sound, source, volume, pitch);
    }

    public static void play(Entity entity, SoundEvent sound) {
        Sound.play(entity, sound, entity.getSoundSource(), 1.0f, 1.0f, 0.0f);
    }

    public static void play(Entity entity, SoundEvent sound, SoundSource source) {
        Sound.play(entity, sound, source, 1.0f, 1.0f, 0.0f);
    }

    public static void play(Entity entity, SoundEvent sound, SoundSource source, float volume, float pitch) {
        Sound.play(entity, sound, source, volume, pitch, 0.0f);
    }

    public static void play(Entity entity, SoundEvent sound, SoundSource source, float volume, float pitch, float pitchVariability) {
        pitch = Sound.vary(pitch, pitchVariability);
        entity.level().playSound(null, entity, sound, source, volume, pitch);
    }

    public static void playSided(Player player, double x, double y, double z, SoundEvent sound, SoundSource source) {
        Sound.playSided(player, x, y, z, sound, source, 1.0f, 1.0f, 0.0f);
    }

    public static void playSided(Player player, double x, double y, double z, SoundEvent sound, SoundSource source, float volume, float pitch) {
        Sound.playSided(player, x, y, z, sound, source, volume, pitch, 0.0f);
    }

    public static void playSided(Player player, double x, double y, double z, SoundEvent sound, SoundSource source, float volume, float pitch, float pitchVariability) {
        pitch = Sound.vary(pitch, pitchVariability);
        player.level().playSound(player, x, y, z, sound, source, volume, pitch);
    }

    public static void playSided(Entity entity, SoundEffect sound) {
        Sound.playSided(entity, sound.get(), entity.getSoundSource(), sound.volume(), sound.pitch(), sound.pitchVariability());
    }

    public static void playSided(Entity entity, SoundEvent sound) {
        Sound.playSided(entity, sound, entity.getSoundSource());
    }

    public static void playSided(Entity entity, SoundEvent sound, SoundSource source) {
        Sound.playSided(entity, sound, source, 1.0f, 1.0f);
    }

    public static void playSided(Entity entity, SoundEvent sound, SoundSource source, float volume, float pitch) {
        Sound.playSided(entity, sound, source, volume, pitch, 0.0f);
    }

    public static void playSided(Entity entity, SoundEvent sound, SoundSource source, float volume, float pitch, float pitchVariability) {
        pitch = Sound.vary(pitch, pitchVariability);
        Player player = entity instanceof Player ? (Player)entity : null;
        entity.level().playSound(player, entity, sound, source, volume, pitch);
    }

    public static void playUnique(String id, Entity entity, SoundEffect sound, SoundSource source) {
        Sound.playUnique(id, entity, sound.get(), source, sound.volume(), sound.pitch(), sound.pitchVariability());
    }

    public static void playUnique(String id, Entity entity, SoundEvent sound, SoundSource source) {
        Sound.playUnique(id, entity, sound, source, 1.0f, 1.0f, 0.0f);
    }

    public static void playUnique(String id, Entity entity, SoundEvent sound, SoundSource source, float volume, float pitch) {
        Sound.playUnique(id, entity, sound, source, volume, pitch, 0.0f);
    }

    public static void playUnique(String id, Entity entity, SoundEvent sound, SoundSource source, float volume, float pitch, float pitchVariability) {
        pitch = Sound.vary(pitch, pitchVariability);
        Level level = entity.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            UniqueSoundPlayS2CP packet = new UniqueSoundPlayS2CP(id, entity.getId(), sound, source, volume, pitch);
            Packets.sendToPlayersNear(packet, serverLevel, null, entity, sound.getRange(1.0f) * 4.0f);
        }
    }

    public static void playUniqueSided(String id, Entity entity, SoundEffect sound, SoundSource source) {
        ServerPlayer player;
        ServerPlayer excludedPlayer = entity instanceof ServerPlayer ? (player = (ServerPlayer)entity) : null;
        float pitch = Sound.vary(sound.pitch(), sound.pitchVariability());
        Level level = entity.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            UniqueSoundPlayS2CP packet = new UniqueSoundPlayS2CP(id, entity.getId(), sound.get(), source, sound.volume(), sound.pitch());
            Packets.sendToPlayersNear(packet, serverLevel, excludedPlayer, entity, sound.get().getRange(1.0f) * 4.0f);
        } else if (entity instanceof Player && entity.level().isClientSide()) {
            UniqueSoundManager.play(id, entity, sound.get(), source, sound.volume(), pitch);
        }
    }

    public static void playUniqueSided(String id, Player player, Entity entity, SoundEffect sound, SoundSource source) {
        Sound.playUniqueSided(id, player, entity, sound.get(), source, sound.volume(), sound.pitch(), sound.pitchVariability());
    }

    public static void playUniqueSided(String id, Player player, Entity entity, SoundEvent sound, SoundSource source, float volume, float pitch, float pitchVariability) {
        pitch = Sound.vary(pitch, pitchVariability);
        Level level = player.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            UniqueSoundPlayS2CP packet = new UniqueSoundPlayS2CP(id, entity.getId(), sound, source, volume, pitch);
            Packets.sendToPlayersNear(packet, serverLevel, (ServerPlayer)player, entity, sound.getRange(1.0f) * 4.0f);
        } else if (player.level().isClientSide()) {
            UniqueSoundManager.play(id, entity, sound, source, volume, pitch);
        }
    }

    private static float vary(float value, float variability) {
        return value - variability / 2.0f + ThreadLocalRandom.current().nextFloat() * variability;
    }

    public static void playShutterTicking(Entity entity, CameraId cameraId, int duration) {
        if (!entity.level().isClientSide()) {
            Packets.sendToAllClients(new UniqueSoundPlayShutterTickingS2CP(entity.getId(), cameraId, 1.0f, 1.0f, duration));
        }
    }
}

