/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.world.item.util;

import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ItemAndStack<T extends Item> {
    private final T item;
    private final ItemStack stack;

    public ItemAndStack(ItemStack stack) {
        this.stack = stack;
        this.item = stack.getItem();
    }

    public T getItem() {
        return this.item;
    }

    public ItemStack getItemStack() {
        return this.stack;
    }

    public ItemAndStack<T> apply(BiConsumer<T, ItemStack> function) {
        function.accept(this.item, this.stack);
        return this;
    }

    public <R> R map(BiFunction<T, ItemStack, R> mappingFunction) {
        return mappingFunction.apply(this.item, this.stack);
    }

    public String toString() {
        return "ItemAndStack{" + this.stack.toString() + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItemAndStack that = (ItemAndStack)o;
        return Objects.equals(this.item, that.item) && Objects.equals(this.stack, that.stack);
    }

    public int hashCode() {
        return Objects.hash(this.item, this.stack);
    }
}

