/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.world.item;

import io.github.mortuusars.exposure.Config;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.client.gui.ClientGUI;
import io.github.mortuusars.exposure.world.item.component.album.SignedAlbumContent;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.util.StringUtil;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SignedAlbumItem
extends Item {
    public SignedAlbumItem(Item.Properties properties) {
        super(properties);
    }

    public SignedAlbumContent getContent(ItemStack stack) {
        return (SignedAlbumContent)stack.getOrDefault(Exposure.DataComponents.SIGNED_ALBUM_CONTENT, (Object)SignedAlbumContent.EMPTY);
    }

    @NotNull
    public Component getName(ItemStack stack) {
        String title;
        @Nullable SignedAlbumContent content = (SignedAlbumContent)stack.get(Exposure.DataComponents.SIGNED_ALBUM_CONTENT);
        if (content != null && !StringUtil.isBlank((String)(title = content.title()))) {
            return Component.literal((String)title);
        }
        return super.getName(stack);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        if (level.isClientSide()) {
            ClientGUI.openAlbumViewScreen(player.getItemInHand(usedHand));
        }
        return InteractionResultHolder.success((Object)player.getItemInHand(usedHand));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        @Nullable SignedAlbumContent content = (SignedAlbumContent)stack.get(Exposure.DataComponents.SIGNED_ALBUM_CONTENT);
        if (content != null) {
            int photographsCount;
            String author = content.author();
            if (!StringUtil.isBlank((String)author)) {
                tooltipComponents.add((Component)Component.translatable((String)"gui.exposure.album.by_author", (Object[])new Object[]{author}).withStyle(ChatFormatting.GRAY));
            }
            if (((Boolean)Config.Client.ALBUM_PHOTOS_COUNT_TOOLTIP.get()).booleanValue() && (photographsCount = (int)content.pages().stream().filter(page -> !page.photograph().isEmpty()).count()) > 0) {
                tooltipComponents.add((Component)Component.translatable((String)"item.exposure.album.tooltip.photos_count", (Object[])new Object[]{photographsCount}));
            }
        }
    }

    public boolean isFoil(ItemStack stack) {
        return (Boolean)Config.Common.SIGNED_ALBUM_GLINT.get();
    }
}

