/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.commands.exposure;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.commands.argument.ColorPaletteArgument;
import io.github.mortuusars.exposure.data.ColorPalette;
import io.github.mortuusars.exposure.util.color.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import javax.imageio.ImageIO;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class PaletteCommand {
    public static LiteralArgumentBuilder<CommandSourceStack> get() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"palette").then(Commands.literal((String)"export").then(((RequiredArgumentBuilder)Commands.argument((String)"palette", (ArgumentType)new ColorPaletteArgument()).then(Commands.literal((String)"json").then(Commands.argument((String)"file_path", (ArgumentType)StringArgumentType.string()).executes(context -> PaletteCommand.exportAsJson((CommandSourceStack)context.getSource(), ColorPaletteArgument.getId((CommandContext)context, (String)"palette"), StringArgumentType.getString((CommandContext)context, (String)"file_path")))))).then(Commands.literal((String)"png").then(Commands.argument((String)"file_path", (ArgumentType)StringArgumentType.string()).executes(context -> PaletteCommand.exportAsPng((CommandSourceStack)context.getSource(), ColorPaletteArgument.getId((CommandContext)context, (String)"palette"), StringArgumentType.getString((CommandContext)context, (String)"file_path")))))))).then(((LiteralArgumentBuilder)Commands.literal((String)"convert").then(Commands.literal((String)"json_to_png").then(Commands.argument((String)"file_path", (ArgumentType)StringArgumentType.string()).executes(context -> PaletteCommand.convertJsonToPng((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"file_path")))))).then(Commands.literal((String)"png_to_json").then(Commands.argument((String)"file_path", (ArgumentType)StringArgumentType.string()).executes(context -> PaletteCommand.convertPngToJson((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"file_path"))))));
    }

    private static int exportAsJson(CommandSourceStack source, ResourceLocation paletteId, String filePath) {
        @Nullable ColorPalette palette = (ColorPalette)source.registryAccess().registryOrThrow(Exposure.Registries.COLOR_PALETTE).get(paletteId);
        if (palette == null) {
            source.sendFailure((Component)Component.literal((String)(String.valueOf(paletteId) + " is not found.")));
            return 0;
        }
        try {
            PaletteCommand.savePaletteAsJson(palette, new File(filePath));
        }
        catch (Exception e) {
            Exposure.LOGGER.error("Exporting palette '{}' failed: ", (Object)paletteId, (Object)e);
            source.sendFailure((Component)Component.literal((String)("Exporting palette '" + String.valueOf(paletteId) + "' failed: " + e.getMessage())));
            return 0;
        }
        source.sendSuccess(() -> Component.literal((String)("Exported palette '" + String.valueOf(paletteId) + "' to file ")).append((Component)Component.literal((String)filePath).withStyle(Style.EMPTY.withUnderlined(Boolean.valueOf(true)))), true);
        return 0;
    }

    private static int exportAsPng(CommandSourceStack source, ResourceLocation paletteId, String filePath) {
        @Nullable ColorPalette palette = (ColorPalette)source.registryAccess().registryOrThrow(Exposure.Registries.COLOR_PALETTE).get(paletteId);
        if (palette == null) {
            source.sendFailure((Component)Component.literal((String)(String.valueOf(paletteId) + " is not found.")));
            return 0;
        }
        try {
            PaletteCommand.savePaletteAsPng(palette, new File(filePath));
            source.sendSuccess(() -> Component.literal((String)("Exported palette '" + String.valueOf(paletteId) + "' to file ")).append((Component)Component.literal((String)filePath).withStyle(Style.EMPTY.withUnderlined(Boolean.valueOf(true)))), true);
        }
        catch (Exception e) {
            Exposure.LOGGER.error("Exporting palette '{}' failed: ", (Object)paletteId, (Object)e);
            source.sendFailure((Component)Component.literal((String)("Exporting palette '" + String.valueOf(paletteId) + "' failed: " + e.getMessage())));
        }
        return 0;
    }

    private static int convertJsonToPng(CommandSourceStack source, String filePath) {
        try {
            File file = new File(filePath);
            ColorPalette palette = PaletteCommand.loadPaletteFromJson(file);
            PaletteCommand.savePaletteAsPng(palette, PaletteCommand.replaceExtension(file, "png"));
            source.sendSuccess(() -> Component.literal((String)("Converted palette '" + filePath + "' to png.")), true);
        }
        catch (Exception e) {
            Exposure.LOGGER.error("Converting palette '{}' failed: ", (Object)filePath, (Object)e);
            source.sendFailure((Component)Component.literal((String)("Converting palette '" + filePath + "' failed: " + e.getMessage())));
        }
        return 0;
    }

    private static int convertPngToJson(CommandSourceStack source, String filePath) {
        try {
            File file = new File(filePath);
            BufferedImage image = ImageIO.read(file);
            Integer[] colors = new Integer[256];
            int addedCount = 0;
            for (int y = 0; y < image.getHeight(); ++y) {
                for (int x = 0; x < image.getWidth() && addedCount <= 255; ++x) {
                    int color = image.getRGB(x, y);
                    if (Color.alpha(color) == 0) {
                        color = Color.TRANSPARENT.getARGB();
                    }
                    boolean alreadyAdded = false;
                    for (Integer addedColor : colors) {
                        if (addedColor == null || !addedColor.equals(color)) continue;
                        alreadyAdded = true;
                        break;
                    }
                    if (alreadyAdded) continue;
                    colors[addedCount] = color;
                    ++addedCount;
                }
            }
            for (int i = addedCount; i < colors.length - 1; ++i) {
                colors[i] = Color.BLACK.getARGB();
            }
            if (colors[255] == null) {
                colors[255] = Color.TRANSPARENT.getARGB();
            }
            if (!colors[255].equals(Color.TRANSPARENT.getARGB())) {
                colors[255] = Color.TRANSPARENT.getARGB();
                source.sendFailure((Component)Component.literal((String)("Corrected last color to be transparent in '" + filePath + "' palette.")));
            }
            ColorPalette palette = new ColorPalette(Arrays.stream(colors).mapToInt(Integer::intValue).toArray());
            try {
                PaletteCommand.savePaletteAsJson(palette, PaletteCommand.replaceExtension(file, "json"));
            }
            catch (Exception e) {
                Exposure.LOGGER.error("Cannot save converted palette '{}' failed: ", (Object)filePath, (Object)e);
                source.sendFailure((Component)Component.literal((String)("Cannot save converted palette '" + filePath + "' failed: " + e.getMessage())));
                return 0;
            }
        }
        catch (Exception e) {
            Exposure.LOGGER.error("Converting palette '{}' failed: ", (Object)filePath, (Object)e);
            source.sendFailure((Component)Component.literal((String)("Converting palette '" + filePath + "' failed: " + e.getMessage())));
            return 0;
        }
        source.sendSuccess(() -> Component.literal((String)("Converted palette '" + filePath + "' to json.")), true);
        return 0;
    }

    private static void savePaletteAsJson(ColorPalette palette, File file) throws IOException {
        JsonElement jsonElement = (JsonElement)ColorPalette.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)palette).getOrThrow();
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String json = gson.toJson(jsonElement);
        try (FileWriter writer = new FileWriter(file);){
            writer.write(json);
        }
    }

    private static void savePaletteAsPng(ColorPalette palette, File file) throws IOException {
        BufferedImage image = new BufferedImage(16, 16, 2);
        int[] colors = palette.colors();
        for (int y = 0; y < 16; ++y) {
            for (int x = 0; x < 16; ++x) {
                image.setRGB(x, y, colors[y * 16 + x]);
            }
        }
        ImageIO.write((RenderedImage)image, "png", file);
    }

    private static ColorPalette loadPaletteFromJson(File file) throws IOException {
        try (FileReader reader = new FileReader(file);){
            JsonObject jsonObject = (JsonObject)new Gson().fromJson((Reader)reader, JsonObject.class);
            ColorPalette colorPalette = (ColorPalette)((Pair)ColorPalette.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)jsonObject).getOrThrow()).getFirst();
            return colorPalette;
        }
    }

    private static File replaceExtension(File originalFile, String newExtension) {
        String originalPath = originalFile.getPath();
        int lastDotIndex = originalPath.lastIndexOf(46);
        String newPath = lastDotIndex == -1 ? originalPath + "." + newExtension : originalPath.substring(0, lastDotIndex) + "." + newExtension;
        return new File(newPath);
    }
}

