/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.commands.exposure;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import io.github.mortuusars.exposure.ExposureServer;
import io.github.mortuusars.exposure.commands.argument.ExposureLookArgument;
import io.github.mortuusars.exposure.commands.argument.SizeMultiplierArgument;
import io.github.mortuusars.exposure.commands.suggestion.ExposureIdSuggestionProvider;
import io.github.mortuusars.exposure.data.export.ExportLook;
import io.github.mortuusars.exposure.data.export.ExportSize;
import io.github.mortuusars.exposure.network.Packets;
import io.github.mortuusars.exposure.network.packet.clientbound.ExportS2CP;
import io.github.mortuusars.exposure.network.packet.clientbound.ExportStopS2CP;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.Nullable;

public class ExportCommand {
    private static final Map<Integer, Long> EXPORT_CONFIRMATIONS = new HashMap<Integer, Long>();

    public static LiteralArgumentBuilder<CommandSourceStack> get() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"export").requires(stack -> stack.hasPermission(3))).then(ExportCommand.id())).then(ExportCommand.all())).then(Commands.literal((String)"stop").executes(context -> {
            Packets.sendToClient(ExportStopS2CP.INSTANCE, ((CommandSourceStack)context.getSource()).getPlayerOrException());
            return 0;
        }));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> id() {
        return Commands.literal((String)"id").then(((RequiredArgumentBuilder)Commands.argument((String)"id", (ArgumentType)StringArgumentType.string()).suggests((SuggestionProvider)new ExposureIdSuggestionProvider()).executes(context -> ExportCommand.exportExposures((CommandSourceStack)context.getSource(), List.of(StringArgumentType.getString((CommandContext)context, (String)"id")), ExportSize.X1, ExportLook.REGULAR))).then(((RequiredArgumentBuilder)Commands.argument((String)"size", (ArgumentType)new SizeMultiplierArgument()).executes(context -> ExportCommand.exportExposures((CommandSourceStack)context.getSource(), List.of(StringArgumentType.getString((CommandContext)context, (String)"id")), SizeMultiplierArgument.getSize(context, "size"), ExportLook.REGULAR))).then(Commands.argument((String)"look", (ArgumentType)new ExposureLookArgument()).executes(context -> ExportCommand.exportExposures((CommandSourceStack)context.getSource(), List.of(StringArgumentType.getString((CommandContext)context, (String)"id")), SizeMultiplierArgument.getSize(context, "size"), ExposureLookArgument.getLook(context, "look"))))));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> all() {
        return ((LiteralArgumentBuilder)Commands.literal((String)"all").executes(context -> ExportCommand.exportAll((CommandSourceStack)context.getSource(), ExportSize.X1, ExportLook.REGULAR))).then(((RequiredArgumentBuilder)Commands.argument((String)"size", (ArgumentType)new SizeMultiplierArgument()).executes(context -> ExportCommand.exportAll((CommandSourceStack)context.getSource(), SizeMultiplierArgument.getSize(context, "size"), ExportLook.REGULAR))).then(Commands.argument((String)"look", (ArgumentType)new ExposureLookArgument()).executes(context -> ExportCommand.exportAll((CommandSourceStack)context.getSource(), SizeMultiplierArgument.getSize(context, "size"), ExposureLookArgument.getLook(context, "look")))));
    }

    private static int exportAll(CommandSourceStack stack, ExportSize size, ExportLook look) throws CommandSyntaxException {
        List<String> ids = ExposureServer.exposureRepository().getAllIds();
        return ExportCommand.confirmExportAll(stack, ids, size, look) ? ExportCommand.exportExposures(stack, ids, size, look) : 0;
    }

    private static boolean confirmExportAll(CommandSourceStack stack, List<String> ids, ExportSize size, ExportLook look) throws CommandSyntaxException {
        boolean confirmed;
        ServerPlayer player = stack.getPlayerOrException();
        int count = ids.size();
        if (count < 50) {
            return true;
        }
        @Nullable Long timestamp = EXPORT_CONFIRMATIONS.get(player.getId());
        boolean bl = confirmed = timestamp != null && player.level().getGameTime() - timestamp < 6000L;
        if (!confirmed) {
            EXPORT_CONFIRMATIONS.put(player.getId(), player.level().getGameTime());
            stack.sendSuccess(() -> Component.translatable((String)"command.exposure.export.confirmation", (Object[])new Object[]{count}).withStyle(Style.EMPTY.withColor(16770531)).append((Component)Component.translatable((String)"command.exposure.export.confirm").withStyle(Style.EMPTY.withColor(16741225).withUnderlined(Boolean.valueOf(true)).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.translatable((String)"command.exposure.export.confirm.tooltip"))).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/exposure export all " + size.getSerializedName() + " " + look.getSerializedName())))), true);
            return false;
        }
        EXPORT_CONFIRMATIONS.remove(player.getId());
        return true;
    }

    private static int exportExposures(CommandSourceStack stack, List<String> exposureIds, ExportSize size, ExportLook look) throws CommandSyntaxException {
        ServerPlayer player = stack.getPlayerOrException();
        Packets.sendToClient(new ExportS2CP(exposureIds, size, look), player);
        return 0;
    }
}

