/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.client.util.bugger;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JsonSyntaxHighlighter {
    private static final String RESET = "\u00a7r";
    private static final String KEYS = "\u00a7b";
    private static final String STRINGS = "\u00a7a";
    private static final String NUMBERS = "\u00a76";
    private static final String BOOLEANS_AND_NULL = "\u00a7c";

    public static String highlight(String json) {
        StringBuilder highlighted = new StringBuilder();
        Pattern pattern = Pattern.compile("(\".*?\"\\s*:)|(\".*?\")|(\\b\\d+\\b)|(\\btrue\\b|\\bfalse\\b|\\bnull\\b)|([{}\\[\\]])");
        Matcher matcher = pattern.matcher(json);
        while (matcher.find()) {
            if (matcher.group(1) != null) {
                matcher.appendReplacement(highlighted, KEYS + matcher.group() + RESET);
                continue;
            }
            if (matcher.group(2) != null) {
                matcher.appendReplacement(highlighted, STRINGS + matcher.group() + RESET);
                continue;
            }
            if (matcher.group(3) != null) {
                matcher.appendReplacement(highlighted, NUMBERS + matcher.group() + RESET);
                continue;
            }
            if (matcher.group(4) != null) {
                matcher.appendReplacement(highlighted, BOOLEANS_AND_NULL + matcher.group() + RESET);
                continue;
            }
            if (matcher.group(5) == null) continue;
            matcher.appendReplacement(highlighted, matcher.group());
        }
        matcher.appendTail(highlighted);
        return highlighted.toString();
    }
}

