/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.client.render.photograph;

import io.github.mortuusars.exposure.ExposureClient;
import io.github.mortuusars.exposure.client.image.modifier.ImageEffect;
import io.github.mortuusars.exposure.client.image.renderable.RenderableImage;
import io.github.mortuusars.exposure.client.render.photograph.PhotographStyles;
import io.github.mortuusars.exposure.world.item.PhotographItem;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public record PhotographStyle(ResourceLocation paperTexture, ResourceLocation overlayTexture, ResourceLocation albumPaperTexture, ResourceLocation albumOverlayTexture, ImageEffect modifier) {
    public static final PhotographStyle REGULAR = new PhotographStyle(ExposureClient.Textures.Photograph.REGULAR_PAPER, ExposureClient.Textures.EMPTY, ExposureClient.Textures.Photograph.REGULAR_ALBUM_PAPER, ExposureClient.Textures.EMPTY, ImageEffect.EMPTY);

    public static PhotographStyle of(ItemStack photographStack) {
        PhotographStyle photographStyle;
        Item item = photographStack.getItem();
        if (item instanceof PhotographItem) {
            PhotographItem photographItem = (PhotographItem)item;
            photographStyle = PhotographStyles.get(photographItem.getType(photographStack));
        } else {
            photographStyle = REGULAR;
        }
        return photographStyle;
    }

    public boolean hasOverlayTexture() {
        return !this.overlayTexture().equals((Object)ExposureClient.Textures.EMPTY);
    }

    public boolean hasAlbumOverlayTexture() {
        return !this.albumOverlayTexture().equals((Object)ExposureClient.Textures.EMPTY);
    }

    public RenderableImage process(RenderableImage image) {
        return !this.modifier.equals(ImageEffect.EMPTY) ? image.modifyWith(this.modifier) : image;
    }
}

