/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.client.gui.screen.element.textbox;

import io.github.mortuusars.exposure.client.gui.screen.element.textbox.HorizontalAlignment;
import io.github.mortuusars.exposure.util.Pos2i;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.StringSplitter;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableInt;

public class DisplayCache {
    public String fullText = "";
    public Pos2i cursorPos = new Pos2i(0, 0);
    public boolean cursorAtEnd = true;
    public int[] lineStarts = new int[]{0};
    public LineInfo[] lines = new LineInfo[]{LineInfo.EMPTY};
    public Rect2i[] selectionAreas = new Rect2i[0];
    public boolean needsRebuilding = true;
    public int x;
    public int y;
    public int width;
    public int height;
    public HorizontalAlignment alignment = HorizontalAlignment.LEFT;

    public int getIndexAtPosition(Font font, Pos2i cursorPosition) {
        int n = cursorPosition.y;
        Objects.requireNonNull(font);
        int lineIndex = n / 9;
        if (lineIndex < 0) {
            return 0;
        }
        if (lineIndex >= this.lines.length) {
            return this.fullText.length();
        }
        LineInfo lineInfo = this.lines[lineIndex];
        return this.lineStarts[lineIndex] + font.getSplitter().plainIndexAtWidth(lineInfo.contents, cursorPosition.x - lineInfo.x, lineInfo.style);
    }

    public int changeLine(int xChange, int yChange) {
        int m;
        int i = this.findLineFromPos(this.lineStarts, xChange);
        int j = i + yChange;
        if (0 <= j && j < this.lineStarts.length) {
            int k = xChange - this.lineStarts[i];
            int l = this.lines[j].contents.length();
            m = this.lineStarts[j] + Math.min(k, l);
        } else {
            m = xChange;
        }
        return m;
    }

    public int findLineStart(int line) {
        int i = this.findLineFromPos(this.lineStarts, line);
        return this.lineStarts[i];
    }

    public int findLineEnd(int line) {
        int i = this.findLineFromPos(this.lineStarts, line);
        return this.lineStarts[i] + this.lines[i].contents.length();
    }

    protected int findLineFromPos(int[] lineStarts, int find) {
        int i = Arrays.binarySearch(lineStarts, find);
        if (i < 0) {
            return -(i + 2);
        }
        return i;
    }

    public void rebuild(Font font, String text, int cursorIndex, int selectionIndex, int x, int y, int width, int height, HorizontalAlignment alignment) {
        Pos2i newCursorPos;
        boolean isCursorAtTextEnd;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.alignment = alignment;
        this.needsRebuilding = false;
        if (text.isEmpty()) {
            this.fullText = "";
            this.cursorPos = new Pos2i(alignment.align(width, font.width("_")), 0);
            this.cursorAtEnd = true;
            this.lineStarts = new int[]{0};
            this.lines = new LineInfo[]{LineInfo.EMPTY};
            this.selectionAreas = new Rect2i[0];
            return;
        }
        IntArrayList lineStartIndexes = new IntArrayList();
        ArrayList lines = new ArrayList();
        MutableInt linesCount = new MutableInt();
        MutableBoolean endsOnNewLine = new MutableBoolean();
        StringSplitter stringSplitter = font.getSplitter();
        stringSplitter.splitLines(text, width, Style.EMPTY, true, (style, lineStartIndex, lineEndIndex) -> {
            int lineIndex = linesCount.getAndIncrement();
            String lineText = text.substring(lineStartIndex, lineEndIndex);
            endsOnNewLine.setValue(lineText.endsWith("\n"));
            lineText = StringUtils.stripEnd((String)lineText, (String)"\n");
            int contentWidth = (int)stringSplitter.stringWidth(lineText);
            int lineXPos = alignment.align(width, contentWidth);
            Objects.requireNonNull(font);
            int lineYPos = lineIndex * 9;
            lineStartIndexes.add(lineStartIndex);
            Objects.requireNonNull(font);
            lines.add(new LineInfo(style, lineText, lineXPos, lineYPos, contentWidth, 9));
        });
        this.fullText = text;
        this.lines = (LineInfo[])lines.toArray(LineInfo[]::new);
        int[] lineStartIndexesArray = lineStartIndexes.toIntArray();
        boolean bl = isCursorAtTextEnd = cursorIndex == text.length();
        if (isCursorAtTextEnd && endsOnNewLine.isTrue()) {
            int n = alignment.align(this.width, font.width("_"));
            int n2 = lines.size();
            Objects.requireNonNull(font);
            newCursorPos = new Pos2i(n, n2 * 9);
        } else {
            int lineIndex = this.findLineFromPos(lineStartIndexesArray, cursorIndex);
            LineInfo line = (LineInfo)lines.get(lineIndex);
            String lineTextToCursor = text.substring(lineStartIndexesArray[lineIndex], cursorIndex);
            int cursorX = line.x + (int)stringSplitter.stringWidth(lineTextToCursor);
            newCursorPos = new Pos2i(cursorX, line.y);
        }
        List selections = cursorIndex != selectionIndex ? this.createSelectionAreas(font, text, this.lines, cursorIndex, selectionIndex, stringSplitter, lineStartIndexesArray) : Collections.emptyList();
        this.cursorPos = newCursorPos;
        this.cursorAtEnd = isCursorAtTextEnd;
        this.lineStarts = lineStartIndexesArray;
        this.selectionAreas = (Rect2i[])selections.toArray(Rect2i[]::new);
    }

    private List<Rect2i> createSelectionAreas(Font font, String fullText, LineInfo[] lines, int cursorPos, int selectionPos, StringSplitter stringSplitter, int[] lineStartIndexesArray) {
        int startIndex = Math.min(cursorPos, selectionPos);
        int endIndex = Math.max(cursorPos, selectionPos);
        int lineAtStart = this.findLineFromPos(lineStartIndexesArray, startIndex);
        int lineAtEnd = this.findLineFromPos(lineStartIndexesArray, endIndex);
        ArrayList<Rect2i> areas = new ArrayList<Rect2i>();
        for (int lineIndex = lineAtStart; lineIndex <= lineAtEnd; ++lineIndex) {
            LineInfo line = lines[lineIndex];
            int lineStartIndex = lineStartIndexesArray[lineIndex];
            String selectedText = fullText.substring(Math.max(startIndex, lineStartIndex), lineIndex == lineAtEnd ? endIndex : lineStartIndexesArray[lineIndex + 1]);
            int selectionWidth = (int)stringSplitter.stringWidth(selectedText);
            String unselectedText = fullText.substring(lineStartIndex, Math.max(startIndex, lineStartIndex));
            int selectionX = startIndex > lineStartIndex ? (int)stringSplitter.stringWidth(unselectedText) : 0;
            int n = line.x + selectionX;
            int n2 = line.y;
            Objects.requireNonNull(font);
            areas.add(new Rect2i(n, n2, selectionWidth, 9));
        }
        return areas;
    }

    public static class LineInfo {
        public static final LineInfo EMPTY = new LineInfo(Style.EMPTY, "", 0, 0, 0, 0);
        public final Style style;
        public final String contents;
        public final Component asComponent;
        public final int x;
        public final int y;
        public final int width;
        public final int height;

        public LineInfo(Style style, String contents, int x, int y, int width, int height) {
            this.style = style;
            this.contents = contents;
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            this.asComponent = Component.literal((String)contents).setStyle(style);
        }
    }
}

