/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.client.capture.saving;

import com.google.common.base.Preconditions;
import com.mojang.logging.LogUtils;
import io.github.mortuusars.exposure.network.Packets;
import io.github.mortuusars.exposure.network.packet.serverbound.ExposureDataC2SP;
import io.github.mortuusars.exposure.world.level.storage.ExposureData;
import java.util.function.Consumer;
import net.minecraft.util.StringUtil;
import org.slf4j.Logger;

public class ExposureUploader {
    private static final Logger LOGGER = LogUtils.getLogger();

    public static void upload(String id, ExposureData exposure) {
        Preconditions.checkArgument((!StringUtil.isBlank((String)id) ? 1 : 0) != 0, (Object)"Cannot upload exposure with null or empty id.");
        LOGGER.debug("Sending exposure '{}' to server...", (Object)id);
        Packets.sendToServer(new ExposureDataC2SP(id, exposure));
    }

    public static Consumer<ExposureData> upload(String id) {
        return exposure -> ExposureUploader.upload(id, exposure);
    }
}

