/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.world.gen.feature;

import cn.leolezury.eternalstarlight.common.registry.ESBlocks;
import cn.leolezury.eternalstarlight.common.util.ESMathUtil;
import cn.leolezury.eternalstarlight.common.world.gen.feature.ESFeature;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;

public class GlaciteFeature
extends ESFeature<NoneFeatureConfiguration> {
    public GlaciteFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel level = context.level();
        BlockPos pos = context.origin();
        RandomSource random = context.random();
        BlockPos toPos = pos.offset(random.nextInt(8, 10) * (random.nextBoolean() ? -1 : 1), random.nextInt(8, 10) * (random.nextBoolean() ? -1 : 1), random.nextInt(8, 10) * (random.nextBoolean() ? -1 : 1));
        BlockHitResult result = level.clip(new ClipContext(pos.getCenter(), toPos.getCenter(), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, CollisionContext.empty()));
        if (result.getType() == HitResult.Type.MISS) {
            return false;
        }
        toPos = result.getBlockPos();
        if (pos.distSqr((Vec3i)toPos) < 144.0) {
            return false;
        }
        BlockPos.MutableBlockPos placePos = new BlockPos.MutableBlockPos();
        for (int x = Math.min(pos.getX(), toPos.getX()); x <= Math.max(pos.getX(), toPos.getX()); ++x) {
            for (int y = Math.min(pos.getY(), toPos.getY()); y <= Math.max(pos.getY(), toPos.getY()); ++y) {
                for (int z = Math.min(pos.getZ(), toPos.getZ()); z <= Math.max(pos.getZ(), toPos.getZ()); ++z) {
                    if (!(ESMathUtil.distSqrBetweenLineAndDot(pos.getX(), pos.getY(), pos.getZ(), toPos.getX(), toPos.getY(), toPos.getZ(), x, y, z) < 1.5)) continue;
                    placePos.set(x, y, z);
                    this.setBlockIfEmpty(level, (BlockPos)placePos, ESBlocks.GLACITE.get().defaultBlockState());
                    for (Direction direction : Direction.values()) {
                        if (random.nextInt(5) != 0) continue;
                        this.setBlockIfEmpty(level, placePos.relative(direction), ESBlocks.GLACITE.get().defaultBlockState());
                    }
                }
            }
        }
        return true;
    }
}

