/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.world.gen.chunkgenerator;

import cn.leolezury.eternalstarlight.common.world.gen.biomesource.ESBiomeSource;
import cn.leolezury.eternalstarlight.common.world.gen.biomesource.IESBiomeSource;
import cn.leolezury.eternalstarlight.common.world.gen.chunkgenerator.IRandomState;
import cn.leolezury.eternalstarlight.common.world.gen.chunkgenerator.StarlightSurfaceSystem;
import cn.leolezury.eternalstarlight.common.world.gen.structure.placement.LandmarkStructurePlacement;
import cn.leolezury.eternalstarlight.common.world.gen.system.BiomeData;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.BiomeResolver;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.levelgen.Beardifier;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.SurfaceSystem;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import net.minecraft.world.level.levelgen.synth.SimplexNoise;
import org.jetbrains.annotations.Nullable;

public class ESChunkGenerator
extends NoiseBasedChunkGenerator {
    private static final BlockState AIR = Blocks.AIR.defaultBlockState();
    private static final BlockState LAVA = Blocks.LAVA.defaultBlockState();
    private final BlockState defaultBlock;
    private final int seaLevel;
    public long seed = 0L;
    private SimplexNoise noise = new SimplexNoise((RandomSource)new WorldgenRandom((RandomSource)new LegacyRandomSource(this.seed)));
    public static final MapCodec<ESChunkGenerator> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BiomeSource.CODEC.fieldOf("biome_source").forGetter(o -> o.biomeSource), (App)NoiseGeneratorSettings.CODEC.fieldOf("settings").forGetter(NoiseBasedChunkGenerator::generatorSettings)).apply((Applicative)instance, instance.stable(ESChunkGenerator::new)));

    public void setSeed(long newSeed) {
        if (this.seed != newSeed) {
            this.noise = new SimplexNoise((RandomSource)new WorldgenRandom((RandomSource)new LegacyRandomSource(newSeed)));
            this.seed = newSeed;
        }
    }

    public ESChunkGenerator(BiomeSource biomeSource, Holder<NoiseGeneratorSettings> settings) {
        super(biomeSource, settings);
        if (settings.isBound()) {
            this.defaultBlock = ((NoiseGeneratorSettings)settings.value()).defaultBlock();
            this.seaLevel = ((NoiseGeneratorSettings)settings.value()).seaLevel();
        } else {
            this.defaultBlock = Blocks.STONE.defaultBlockState();
            this.seaLevel = 50;
        }
    }

    public ChunkGeneratorStructureState createState(HolderLookup<StructureSet> holderLookup, RandomState randomState, long seed) {
        this.setSeed(seed);
        BiomeSource biomeSource = this.biomeSource;
        if (biomeSource instanceof ESBiomeSource) {
            ESBiomeSource source = (ESBiomeSource)biomeSource;
            source.setSeed(seed);
        }
        return super.createState(holderLookup, randomState, seed);
    }

    protected MapCodec<? extends ChunkGenerator> codec() {
        return CODEC;
    }

    protected ChunkAccess doFill(Blender blender, StructureManager structureManager, RandomState randomState, ChunkAccess chunkAccess, int i, int j) {
        ESBiomeSource.Cached cached;
        ChunkPos chunkPos = chunkAccess.getPos();
        Beardifier beardifier = Beardifier.forStructuresInChunk((StructureManager)structureManager, (ChunkPos)chunkPos);
        Heightmap oceanFloorMap = chunkAccess.getOrCreateHeightmapUnprimed(Heightmap.Types.OCEAN_FLOOR_WG);
        Heightmap worldSurfaceMap = chunkAccess.getOrCreateHeightmapUnprimed(Heightmap.Types.WORLD_SURFACE_WG);
        int minBlockX = chunkPos.getMinBlockX();
        int minBlockZ = chunkPos.getMinBlockZ();
        int minY = this.getMinY();
        int minYSec = Math.floorDiv(minY, 16);
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        int cellWidth = 16;
        int cellHeight = 16;
        int numSec = chunkAccess.getSections().length;
        BiomeSource biomeSource = this.biomeSource;
        if (biomeSource instanceof ESBiomeSource) {
            ESBiomeSource source = (ESBiomeSource)biomeSource;
            cached = source.cache();
        } else {
            cached = null;
        }
        ESBiomeSource.Cached cachedBiomeSource = cached;
        for (int secY = numSec - 1; secY >= 0; --secY) {
            LevelChunkSection levelChunkSection = chunkAccess.getSection(secY);
            for (int relativeY = cellHeight - 1; relativeY >= 0; --relativeY) {
                int worldY = (minYSec + secY) * cellHeight + relativeY;
                int blockYInCell = worldY & 0xF;
                for (int cellBlockX = 0; cellBlockX < cellWidth; ++cellBlockX) {
                    int worldX = minBlockX + cellBlockX;
                    int blockXInCell = worldX & 0xF;
                    for (int cellBlockZ = 0; cellBlockZ < cellWidth; ++cellBlockZ) {
                        double beard;
                        int worldZ = minBlockZ + cellBlockZ;
                        int blockZInCell = worldZ & 0xF;
                        int surfaceHeight = this.getSurfaceHeight(cachedBiomeSource, worldX, worldZ);
                        BlockState blockState = this.getStateAt(worldY, surfaceHeight, this.getBiomeDataAt(cachedBiomeSource, worldX, worldZ));
                        double noiseVal = this.noise.getValue((double)worldX / 50.0, (double)worldY / 30.0, (double)worldZ / 50.0);
                        if (worldY < surfaceHeight - 15 && worldY > minY + 2 && (worldY > minY + 4 || (int)(noiseVal * 200.0) % 5 == 0) && noiseVal < -0.3) {
                            BlockState blockState2 = blockState = worldY > minY + 8 ? AIR : LAVA;
                        }
                        if ((beard = beardifier.compute((DensityFunction.FunctionContext)new DensityFunction.SinglePointContext(worldX, worldY, worldZ))) > 0.1) {
                            blockState = this.defaultBlock;
                        }
                        if (blockState == AIR) continue;
                        levelChunkSection.setBlockState(blockXInCell, blockYInCell, blockZInCell, blockState, false);
                        oceanFloorMap.update(blockXInCell, worldY, blockZInCell, blockState);
                        worldSurfaceMap.update(blockXInCell, worldY, blockZInCell, blockState);
                        if (blockState.getFluidState().isEmpty()) continue;
                        mutableBlockPos.set(worldX, worldY, worldZ);
                        chunkAccess.markPosForPostprocessing((BlockPos)mutableBlockPos);
                    }
                }
            }
        }
        return chunkAccess;
    }

    protected void doCreateBiomes(Blender blender, RandomState randomState, StructureManager structureManager, ChunkAccess chunkAccess) {
        BiomeSource biomeSource = this.biomeSource;
        if (biomeSource instanceof ESBiomeSource) {
            ESBiomeSource source = (ESBiomeSource)biomeSource;
            source.setRegistryAccess(structureManager.registryAccess());
            chunkAccess.fillBiomesFromNoise((BiomeResolver)source.cache(), randomState.sampler());
        } else {
            chunkAccess.fillBiomesFromNoise((BiomeResolver)this.biomeSource, randomState.sampler());
        }
    }

    public void buildSurface(WorldGenRegion worldGenRegion, StructureManager structureManager, RandomState randomState, ChunkAccess chunkAccess) {
        SurfaceSystem surfaceSystem = randomState.surfaceSystem();
        if (surfaceSystem instanceof StarlightSurfaceSystem) {
            StarlightSurfaceSystem system = (StarlightSurfaceSystem)surfaceSystem;
            system.setStarlightChunkGenerator(this);
            BiomeSource biomeSource = this.biomeSource;
            if (biomeSource instanceof ESBiomeSource) {
                ESBiomeSource source = (ESBiomeSource)biomeSource;
                randomState = ((IRandomState)randomState).clone();
                SurfaceSystem clonedSurfaceSystem = ((StarlightSurfaceSystem)randomState.surfaceSystem()).clone();
                ((IRandomState)randomState).setSurfaceSystem(clonedSurfaceSystem);
                ((StarlightSurfaceSystem)clonedSurfaceSystem).setCachedStarlightBiomeSource(source.cache());
            }
        }
        super.buildSurface(worldGenRegion, structureManager, randomState, chunkAccess);
    }

    public int getBaseHeight(int x, int z, Heightmap.Types types, LevelHeightAccessor levelHeightAccessor, RandomState randomState) {
        return this.getSurfaceHeight(x, z);
    }

    public NoiseColumn getBaseColumn(int x, int z, LevelHeightAccessor levelHeightAccessor, RandomState randomState) {
        BlockState[] states = new BlockState[((NoiseGeneratorSettings)this.generatorSettings().value()).noiseSettings().clampToHeightAccessor(levelHeightAccessor).height()];
        this.iterateTerrainColumn(x, z, states, null, levelHeightAccessor);
        return new NoiseColumn(levelHeightAccessor.getMinBuildHeight(), states);
    }

    private int iterateTerrainColumn(int x, int z, BlockState[] states, @Nullable Predicate<BlockState> statePredicate, LevelHeightAccessor level) {
        int surfaceHeight = this.getSurfaceHeight(x, z);
        int maxHeight = level.getMaxBuildHeight();
        int height = level.getMinBuildHeight();
        BiomeData data = this.getBiomeDataAt(x, z);
        int index = 0;
        while (height < maxHeight) {
            BlockState state = this.getStateAt(height, surfaceHeight, data);
            if (statePredicate != null && !statePredicate.test(state)) continue;
            states[index] = state;
            ++index;
            ++height;
        }
        return states.length;
    }

    private BlockState getStateAt(int y, int surfaceHeight, BiomeData data) {
        BlockState state = y <= surfaceHeight ? this.defaultBlock : (y <= this.seaLevel ? ((Block)data.fluidBlock().value()).defaultBlockState() : AIR);
        return state;
    }

    public int getSurfaceHeight(int x, int z) {
        BiomeSource biomeSource = this.biomeSource;
        if (biomeSource instanceof ESBiomeSource) {
            ESBiomeSource source = (ESBiomeSource)biomeSource;
            return source.getHeight(x, z);
        }
        return 0;
    }

    public int getSurfaceHeight(IESBiomeSource source, int x, int z) {
        if (source != null) {
            return source.getHeight(x, z);
        }
        return 0;
    }

    private BiomeData getBiomeDataAt(int x, int z) {
        BiomeSource biomeSource = this.biomeSource;
        if (biomeSource instanceof ESBiomeSource) {
            ESBiomeSource source = (ESBiomeSource)biomeSource;
            return source.getBiomeData(x, z);
        }
        return null;
    }

    private BiomeData getBiomeDataAt(IESBiomeSource source, int x, int z) {
        if (source != null) {
            return source.getBiomeData(x, z);
        }
        return null;
    }

    @Nullable
    public Pair<BlockPos, Holder<Structure>> findNearestMapStructure(ServerLevel level, HolderSet<Structure> structure, BlockPos pos, int searchRadius, boolean skipKnownStructures) {
        Pair mapStructure = super.findNearestMapStructure(level, structure, pos, searchRadius, skipKnownStructures);
        if (mapStructure != null) {
            return mapStructure;
        }
        ChunkGeneratorStructureState structureState = level.getChunkSource().getGeneratorState();
        Object2ObjectArrayMap placements = new Object2ObjectArrayMap();
        for (Holder structureHolder : structure) {
            for (StructurePlacement structurePlacement : structureState.getPlacementsForStructure(structureHolder)) {
                placements.computeIfAbsent(structurePlacement, placement -> new ObjectArraySet()).add(structureHolder);
            }
        }
        if (placements.isEmpty()) {
            return null;
        }
        Pair result = null;
        double currentDist = Double.MAX_VALUE;
        StructureManager structureManager = level.structureManager();
        ArrayList list = new ArrayList(placements.size());
        for (Map.Entry entry : placements.entrySet()) {
            if (!(entry.getKey() instanceof LandmarkStructurePlacement)) continue;
            list.add(entry);
        }
        if (!list.isEmpty()) {
            int chunkX = SectionPos.blockToSectionCoord((int)pos.getX());
            int chunkZ = SectionPos.blockToSectionCoord((int)pos.getZ());
            for (int currentRadius = 0; currentRadius <= searchRadius; ++currentRadius) {
                boolean found = false;
                for (Map.Entry entry : list) {
                    Pair currentStructure = null;
                    for (int x = -currentRadius; x <= currentRadius; ++x) {
                        boolean xSide = x == -currentRadius || x == currentRadius;
                        for (int z = -currentRadius; z <= currentRadius; ++z) {
                            boolean zSide;
                            boolean bl = zSide = z == -currentRadius || z == currentRadius;
                            if (!xSide && !zSide) continue;
                            ChunkPos landmarkPos = LandmarkStructurePlacement.getRegionLandmarkPos(structureState, x + chunkX, z + chunkZ);
                            if (landmarkPos.x != x + chunkX || landmarkPos.z != z + chunkZ) continue;
                            currentStructure = ESChunkGenerator.getStructureGeneratingAt((Set)((Set)entry.getValue()), (LevelReader)level, (StructureManager)structureManager, (boolean)skipKnownStructures, (StructurePlacement)((StructurePlacement)entry.getKey()), (ChunkPos)landmarkPos);
                        }
                    }
                    if (currentStructure == null) continue;
                    found = true;
                    double dist = pos.distSqr((Vec3i)currentStructure.getFirst());
                    if (!(dist < currentDist)) continue;
                    currentDist = dist;
                    result = currentStructure;
                }
                if (!found) continue;
                return result;
            }
        }
        return result;
    }
}

