/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.entity.projectile;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.client.ESRenderType;
import cn.leolezury.eternalstarlight.common.data.ESDamageTypes;
import cn.leolezury.eternalstarlight.common.entity.interfaces.TrailOwner;
import cn.leolezury.eternalstarlight.common.registry.ESEntities;
import cn.leolezury.eternalstarlight.common.util.TrailEffect;
import java.util.UUID;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector4f;

public class EnergySpark
extends ThrowableProjectile
implements TrailOwner {
    private static final ResourceLocation TRAIL_TEXTURE = EternalStarlight.id("textures/entity/trail.png");
    private static final String TAG_TARGET = "target";
    private static final String TAG_SPAWNED_TICKS = "spawned_ticks";
    public float oSpin;
    public float spin;
    protected static final EntityDataAccessor<Integer> SPAWNED_TICKS = SynchedEntityData.defineId(EnergySpark.class, (EntityDataSerializer)EntityDataSerializers.INT);
    @Nullable
    private LivingEntity target;
    @Nullable
    private UUID targetId;

    public int getSpawnedTicks() {
        return (Integer)this.getEntityData().get(SPAWNED_TICKS);
    }

    public void setSpawnedTicks(int spawnedTicks) {
        this.getEntityData().set(SPAWNED_TICKS, (Object)spawnedTicks);
    }

    public EnergySpark(EntityType<? extends EnergySpark> entityType, Level level) {
        super(entityType, level);
    }

    public EnergySpark(Level level, LivingEntity livingEntity) {
        super(ESEntities.ENERGY_SPARK.get(), livingEntity, level);
    }

    public EnergySpark(Level level, double x, double y, double z) {
        super(ESEntities.ENERGY_SPARK.get(), x, y, z, level);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(SPAWNED_TICKS, (Object)0);
    }

    public LivingEntity getTarget() {
        return this.target;
    }

    public void setTarget(LivingEntity target) {
        this.targetId = target.getUUID();
        this.target = target;
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            Vec3 delta;
            Vec3 targetPos;
            Level level;
            if (this.target == null && this.targetId != null && (level = this.level()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                Entity entity = serverLevel.getEntity(this.targetId);
                if (entity instanceof LivingEntity) {
                    LivingEntity livingEntity;
                    this.target = livingEntity = (LivingEntity)entity;
                }
                if (this.target == null) {
                    this.targetId = null;
                }
            }
            if (this.target != null && !this.target.isAlive()) {
                this.target = null;
                this.targetId = null;
            }
            Vec3 vec3 = targetPos = this.getOwner() instanceof Player ? this.position().add((double)this.getRandom().nextInt(-10, 11), (double)this.getRandom().nextInt(-10, 11), (double)this.getRandom().nextInt(-10, 11)) : this.position().add(this.getDeltaMovement().normalize());
            if (this.target != null && (this.getOwner() instanceof Player || this.tickCount < 80)) {
                targetPos = this.target.position().add(0.0, (double)(this.target.getBbHeight() / 2.0f), 0.0);
            }
            if (this.getSpawnedTicks() <= 40 && this.tickCount % 2 == 0 && this.getOwner() instanceof Player) {
                delta = new Vec3((double)this.getRandom().nextFloat() - 0.5, (double)this.getRandom().nextFloat() - 0.5, (double)this.getRandom().nextFloat() - 0.5);
                double length = this.getDeltaMovement().length();
                this.setDeltaMovement(this.getDeltaMovement().add(delta.normalize().scale(Math.max(length * 0.05, 0.005))).normalize().scale(length));
            }
            if (this.getSpawnedTicks() > 40) {
                delta = targetPos.subtract(this.position());
                double lengthSqr = delta.lengthSqr();
                if (lengthSqr < 100.0) {
                    double e = 1.0 - Math.sqrt(lengthSqr) / 10.0;
                    this.setDeltaMovement(this.getDeltaMovement().add(delta.normalize().scale(e * e * 0.03)));
                } else {
                    this.setDeltaMovement(this.getDeltaMovement().add(delta.normalize().scale(0.05)));
                }
                if (this.target != null && this.target.getBoundingBox().intersects(this.getBoundingBox())) {
                    this.hurtTarget((Entity)this.target);
                }
            }
            if (this.getSpawnedTicks() > (this.getOwner() instanceof Player ? 600 : 120)) {
                this.discard();
            }
            this.setSpawnedTicks(this.getSpawnedTicks() + 1);
        }
        this.oSpin = this.spin;
        this.spin += 0.18849556f * ((float)this.getSpawnedTicks() / 100.0f);
    }

    protected void applyGravity() {
    }

    protected void onHitBlock(BlockHitResult hitResult) {
        super.onHitBlock(hitResult);
        switch (hitResult.getDirection().getAxis()) {
            case X: {
                this.setDeltaMovement(this.getDeltaMovement().multiply(-1.0, 1.0, 1.0));
                break;
            }
            case Y: {
                this.setDeltaMovement(this.getDeltaMovement().multiply(1.0, -1.0, 1.0));
                break;
            }
            case Z: {
                this.setDeltaMovement(this.getDeltaMovement().multiply(1.0, 1.0, -1.0));
            }
        }
    }

    protected void onHitEntity(EntityHitResult hitResult) {
        super.onHitEntity(hitResult);
        this.hurtTarget(hitResult.getEntity());
    }

    private void hurtTarget(Entity entity) {
        if ((this.getTarget() == null || entity == this.getTarget()) && entity != this.getOwner()) {
            entity.invulnerableTime = 0;
            entity.hurt(ESDamageTypes.getIndirectEntityDamageSource(this.level(), ESDamageTypes.ENERGIZED_FLAME, (Entity)this, this.getOwner()), 3.0f);
        }
        this.discard();
    }

    public void readAdditionalSaveData(CompoundTag compoundTag) {
        super.readAdditionalSaveData(compoundTag);
        if (compoundTag.hasUUID(TAG_TARGET)) {
            this.targetId = compoundTag.getUUID(TAG_TARGET);
        }
        this.setSpawnedTicks(compoundTag.getInt(TAG_SPAWNED_TICKS));
    }

    public void addAdditionalSaveData(CompoundTag compoundTag) {
        super.addAdditionalSaveData(compoundTag);
        if (this.target != null) {
            compoundTag.putUUID(TAG_TARGET, this.target.getUUID());
        }
        compoundTag.putInt(TAG_SPAWNED_TICKS, this.getSpawnedTicks());
    }

    @Override
    public TrailEffect newTrail() {
        return new TrailEffect(0.125f, 3);
    }

    @Override
    public void updateTrail(TrailEffect effect) {
        Vec3 oldPos = new Vec3(this.xOld, this.yOld, this.zOld);
        effect.update(oldPos.add(0.0, (double)(this.getBbHeight() / 2.0f), 0.0));
        if (this.isRemoved()) {
            effect.setLength(Math.max(effect.getLength() - 0.5f, 0.0f));
        }
    }

    @Override
    public Vector4f getTrailColor() {
        return new Vector4f(0.5019608f, 1.0f, 1.0f, 2.0f);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public RenderType getTrailRenderType() {
        return ESRenderType.entityTranslucentGlow(TRAIL_TEXTURE);
    }
}

