/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.entity.living.boss.golem;

import cn.leolezury.eternalstarlight.common.block.EnergyBlock;
import cn.leolezury.eternalstarlight.common.config.ESConfig;
import cn.leolezury.eternalstarlight.common.data.ESCrests;
import cn.leolezury.eternalstarlight.common.entity.attack.EnergizedFlame;
import cn.leolezury.eternalstarlight.common.entity.interfaces.RayAttackUser;
import cn.leolezury.eternalstarlight.common.entity.living.boss.ESBoss;
import cn.leolezury.eternalstarlight.common.entity.living.boss.ESServerBossEvent;
import cn.leolezury.eternalstarlight.common.entity.living.boss.golem.StarlightGolemChargeEndPhase;
import cn.leolezury.eternalstarlight.common.entity.living.boss.golem.StarlightGolemChargePhase;
import cn.leolezury.eternalstarlight.common.entity.living.boss.golem.StarlightGolemChargeStartPhase;
import cn.leolezury.eternalstarlight.common.entity.living.boss.golem.StarlightGolemLaserBeamPhase;
import cn.leolezury.eternalstarlight.common.entity.living.boss.golem.StarlightGolemSmashPhase;
import cn.leolezury.eternalstarlight.common.entity.living.boss.golem.StarlightGolemSummonFlamePhase;
import cn.leolezury.eternalstarlight.common.entity.living.goal.LookAtTargetGoal;
import cn.leolezury.eternalstarlight.common.entity.living.phase.BehaviorManager;
import cn.leolezury.eternalstarlight.common.network.ParticlePacket;
import cn.leolezury.eternalstarlight.common.particle.ESExplosionParticleOptions;
import cn.leolezury.eternalstarlight.common.particle.ExplosionShockParticleOptions;
import cn.leolezury.eternalstarlight.common.particle.RingExplosionParticleOptions;
import cn.leolezury.eternalstarlight.common.platform.ESPlatform;
import cn.leolezury.eternalstarlight.common.registry.ESBlocks;
import cn.leolezury.eternalstarlight.common.registry.ESDataAttachments;
import cn.leolezury.eternalstarlight.common.registry.ESEntities;
import cn.leolezury.eternalstarlight.common.registry.ESParticles;
import cn.leolezury.eternalstarlight.common.registry.ESPoiTypes;
import cn.leolezury.eternalstarlight.common.registry.ESSoundEvents;
import cn.leolezury.eternalstarlight.common.util.ESBlockUtil;
import cn.leolezury.eternalstarlight.common.util.ESCrestUtil;
import cn.leolezury.eternalstarlight.common.util.ESTags;
import cn.leolezury.eternalstarlight.common.vfx.ScreenShakeVfx;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;

public class StarlightGolem
extends ESBoss
implements RayAttackUser {
    private final ESServerBossEvent bossEvent = new ESServerBossEvent(this, this.getUUID(), BossEvent.BossBarColor.BLUE, false);
    private final BehaviorManager<StarlightGolem> behaviorManager = new BehaviorManager<StarlightGolem>(this, List.of(new StarlightGolemLaserBeamPhase(), new StarlightGolemSummonFlamePhase(), new StarlightGolemSmashPhase(), new StarlightGolemChargeStartPhase(), new StarlightGolemChargePhase(), new StarlightGolemChargeEndPhase()));
    public AnimationState laserBeamAnimationState = new AnimationState();
    public AnimationState summonFlameAnimationState = new AnimationState();
    public AnimationState smashAnimationState = new AnimationState();
    public AnimationState chargeStartAnimationState = new AnimationState();
    public AnimationState chargeAnimationState = new AnimationState();
    public AnimationState chargeEndAnimationState = new AnimationState();
    public AnimationState deathAnimationState = new AnimationState();
    public int oldDeathAnimationTime;
    public int deathAnimationTime;
    private int attackEnergy;
    private int lastHurtCount;
    private int chargeHurtCount;
    private float chargeHurtAmount;
    private int lastHurtSound;
    private boolean hasProtection;

    public StarlightGolem(EntityType<? extends StarlightGolem> entityType, Level level) {
        super(entityType, level);
    }

    public void clearChargeHurtCountAndAmount() {
        this.chargeHurtCount = 0;
        this.chargeHurtAmount = 0.0f;
    }

    public int getChargeHurtCount() {
        return this.chargeHurtCount;
    }

    public float getChargeHurtAmount() {
        return this.chargeHurtAmount;
    }

    public int getAttackEnergy() {
        return this.attackEnergy;
    }

    public void setAttackEnergy(int energy) {
        this.attackEnergy = energy;
    }

    public boolean hasProtection() {
        return this.hasProtection;
    }

    public BehaviorManager<StarlightGolem> getBehaviorManager() {
        return this.behaviorManager;
    }

    @Override
    public void readAdditionalSaveData(CompoundTag compoundTag) {
        super.readAdditionalSaveData(compoundTag);
        this.bossEvent.setId(this.getUUID());
    }

    public void startSeenByPlayer(ServerPlayer serverPlayer) {
        super.startSeenByPlayer(serverPlayer);
        this.bossEvent.addPlayer(serverPlayer);
    }

    public void stopSeenByPlayer(ServerPlayer serverPlayer) {
        super.stopSeenByPlayer(serverPlayer);
        this.bossEvent.removePlayer(serverPlayer);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new GolemLookAtTargetGoal());
        this.goalSelector.addGoal(2, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.goalSelector.addGoal(3, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.targetSelector.addGoal(0, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{StarlightGolem.class}).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, true));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    @Override
    public boolean isRayFollowingHeadRotation() {
        return false;
    }

    @Override
    public Vec3 getRayRotationTarget() {
        return this.getTarget() == null ? this.position().add((double)(this.getBbWidth() * (this.getRandom().nextFloat() - 0.5f)), (double)(this.getBbHeight() * this.getRandom().nextFloat()), (double)(this.getBbWidth() * (this.getRandom().nextFloat() - 0.5f))) : this.getTarget().position().add(0.0, (double)(this.getTarget().getBbHeight() / 2.0f), 0.0);
    }

    @Override
    public void updateRayEnd(Vec3 endPos) {
        this.lookAt(EntityAnchorArgument.Anchor.EYES, endPos);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, ESConfig.INSTANCE.mobsConfig.starlightGolem.maxHealth()).add(Attributes.ARMOR, ESConfig.INSTANCE.mobsConfig.starlightGolem.armor()).add(Attributes.FOLLOW_RANGE, ESConfig.INSTANCE.mobsConfig.starlightGolem.followRange()).add(Attributes.MOVEMENT_SPEED, 0.0).add(Attributes.ATTACK_DAMAGE, 0.0).add(Attributes.KNOCKBACK_RESISTANCE, 1.0);
    }

    public boolean isInvulnerableTo(DamageSource source) {
        return super.isInvulnerableTo(source) || source.getEntity() == this || source.is(DamageTypes.FALLING_BLOCK);
    }

    @Override
    public boolean hurt(DamageSource source, float amount) {
        if (!source.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
            if (!this.hasProtection()) {
                if (source.getEntity() != null && source.getEntity() != this) {
                    if (this.tickCount - this.lastHurtCount > 10) {
                        ++this.chargeHurtCount;
                        this.lastHurtCount = this.tickCount;
                    }
                    this.chargeHurtAmount += amount;
                }
            } else {
                if (source.getDirectEntity() instanceof LivingEntity && this.tickCount - this.lastHurtSound > 20) {
                    this.playSound(ESSoundEvents.STARLIGHT_GOLEM_BLOCK.get(), this.getSoundVolume(), this.getVoicePitch());
                    this.lastHurtSound = this.tickCount;
                }
                return false;
            }
        }
        boolean success = super.hurt(source, amount);
        if (this.getPhase() == 0 && (double)(this.getHealth() / this.getMaxHealth()) < 0.2) {
            this.setPhase(1);
        }
        return success;
    }

    protected void tickDeath() {
        if (this.deathAnimationTime == 0) {
            this.stopAllAnimStates();
            this.deathAnimationState.start(this.tickCount);
            this.setBehaviorState(0);
        }
        this.oldDeathAnimationTime = this.deathAnimationTime++;
        if (this.deathAnimationTime == 110 && !this.level().isClientSide()) {
            this.level().broadcastEntityEvent((Entity)this, (byte)60);
            this.playSound((SoundEvent)SoundEvents.GENERIC_EXPLODE.value());
            Level level = this.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.sendParticles((ParticleOptions)ESExplosionParticleOptions.ENERGY, this.getX(), this.getY() + (double)(this.getBbHeight() / 2.0f), this.getZ(), 20, (double)(this.getBbWidth() / 2.0f), (double)(this.getBbHeight() / 2.0f), (double)(this.getBbWidth() / 2.0f), 0.0);
                serverLevel.sendParticles((ParticleOptions)ESParticles.BIG_EXPLOSION.get(), this.getX(), this.getY() + (double)(this.getBbHeight() / 2.0f), this.getZ(), 5, (double)(this.getBbWidth() / 2.0f), (double)(this.getBbHeight() / 2.0f), (double)(this.getBbWidth() / 2.0f), 0.0);
                for (int i = 0; i < 25; ++i) {
                    Vec3 speed = new Vec3((double)((this.random.nextFloat() - this.random.nextFloat()) * 0.1f), (double)(this.random.nextFloat() * 0.05f), (double)((this.random.nextFloat() - this.random.nextFloat()) * 0.1f)).normalize();
                    ESPlatform.INSTANCE.sendToAllClients(serverLevel, new ParticlePacket(ExplosionShockParticleOptions.ENERGY, this.position().x + speed.x * 1.2, this.position().y + speed.y * 1.2, this.position().z + speed.z * 1.2, speed.x, speed.y, speed.z));
                }
                ScreenShakeVfx.createInstance((ResourceKey<Level>)this.level().dimension(), this.position(), 40.0f, 50, 0.5f, 0.5f, 3.0f, 5.5f).send(serverLevel);
            }
            this.remove(Entity.RemovalReason.KILLED);
        }
    }

    public void stopAllAnimStates() {
        this.laserBeamAnimationState.stop();
        this.summonFlameAnimationState.stop();
        this.smashAnimationState.stop();
        this.chargeStartAnimationState.stop();
        this.chargeAnimationState.stop();
        this.chargeEndAnimationState.stop();
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> accessor) {
        if (accessor.equals((Object)BEHAVIOR_STATE) && this.getBehaviorState() != 0) {
            this.stopAllAnimStates();
            switch (this.getBehaviorState()) {
                case 1: {
                    this.laserBeamAnimationState.start(this.tickCount);
                    break;
                }
                case 2: {
                    this.summonFlameAnimationState.start(this.tickCount);
                    break;
                }
                case 3: {
                    this.smashAnimationState.start(this.tickCount);
                    break;
                }
                case 4: {
                    this.chargeStartAnimationState.start(this.tickCount);
                    break;
                }
                case 5: {
                    this.chargeAnimationState.start(this.tickCount);
                    break;
                }
                case 6: {
                    this.chargeEndAnimationState.start(this.tickCount);
                }
            }
        }
        super.onSyncedDataUpdated(accessor);
    }

    public boolean isPushable() {
        return false;
    }

    public boolean isAlliedTo(Entity entity) {
        return super.isAlliedTo(entity) || entity.getType().is(ESTags.EntityTypes.STARLIGHT_GOLEM_ALLYS);
    }

    public boolean canStandOnFluid(FluidState fluidState) {
        return super.canStandOnFluid(fluidState) || fluidState.is(FluidTags.LAVA);
    }

    @Override
    public boolean canBossMove() {
        return this.getPhase() != 0;
    }

    private List<BlockPos> getNearbyEnergyBlocks(boolean lit) {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            PoiManager poiManager = serverLevel.getPoiManager();
            return poiManager.findAllClosestFirstWithType(poi -> poi.is(ESPoiTypes.ENERGY_BLOCK.getResourceKey()), pos -> {
                BlockState state = serverLevel.getBlockState(pos);
                return !lit || state.hasProperty((Property)EnergyBlock.LIT) && (Boolean)state.getValue((Property)EnergyBlock.LIT) != false;
            }, this.blockPosition(), 48, PoiManager.Occupancy.ANY).limit(5L).map(Pair::getSecond).toList();
        }
        return List.of();
    }

    public void turnOnEnergyBlocks() {
        List<BlockPos> list = this.getNearbyEnergyBlocks(false);
        for (BlockPos pos : list) {
            BlockState state = this.level().getBlockState(pos);
            if (!state.is((Block)ESBlocks.ENERGY_BLOCK.get()) || ((Boolean)state.getValue((Property)BlockStateProperties.LIT)).booleanValue()) continue;
            this.level().setBlockAndUpdate(pos, (BlockState)state.setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(true)));
            Level level = this.level();
            if (!(level instanceof ServerLevel)) continue;
            ServerLevel serverLevel = (ServerLevel)level;
            Vec3 center = pos.getCenter();
            ESPlatform.INSTANCE.sendToAllClients(serverLevel, new ParticlePacket(RingExplosionParticleOptions.ENERGY, center.x(), center.y(), center.z(), 0.0, 0.2, 0.0));
        }
    }

    public void spawnEnergizedFlame(int maxNum, int scanRadius, boolean trackTarget) {
        EnergizedFlame energizedFlame;
        int left = maxNum;
        LivingEntity target = this.getTarget();
        if (trackTarget && target != null && (energizedFlame = (EnergizedFlame)ESEntities.ENERGIZED_FLAME.get().create(this.level())) != null) {
            energizedFlame.setPos(target.position().add(ESDataAttachments.MOVEMENT.getData((Entity)target).scale(20.0)));
            energizedFlame.setOwner((LivingEntity)this);
            this.level().addFreshEntity((Entity)energizedFlame);
            --left;
        }
        ArrayList<BlockPos> possiblePositions = new ArrayList<BlockPos>();
        for (int x = -scanRadius; x <= scanRadius; ++x) {
            for (int z = -scanRadius; z <= scanRadius; ++z) {
                for (int y = -5; y <= 5; ++y) {
                    BlockPos firePos = this.blockPosition().offset(x, y, z);
                    if (!this.level().isEmptyBlock(firePos) || !this.level().getBlockState(firePos.below()).isFaceSturdy((BlockGetter)this.level(), firePos.below(), Direction.UP)) continue;
                    possiblePositions.add(firePos);
                }
            }
        }
        for (int i = 0; i < left; ++i) {
            if (possiblePositions.isEmpty()) continue;
            BlockPos firePos = (BlockPos)possiblePositions.get(this.getRandom().nextInt(possiblePositions.size()));
            EnergizedFlame energizedFlame2 = (EnergizedFlame)ESEntities.ENERGIZED_FLAME.get().create(this.level());
            energizedFlame2.setPos(firePos.getBottomCenter());
            energizedFlame2.setOwner((LivingEntity)this);
            this.level().addFreshEntity((Entity)energizedFlame2);
            possiblePositions.remove(firePos);
        }
    }

    public void aiStep() {
        block12: {
            block11: {
                super.aiStep();
                this.bossEvent.update();
                if (this.level().isClientSide) break block11;
                if (this.getTarget() != null && !this.getTarget().isAlive()) {
                    this.setTarget(null);
                }
                if (!this.isNoAi() && this.isAlive()) {
                    this.behaviorManager.tick();
                }
                List<BlockPos> list = this.getNearbyEnergyBlocks(true);
                Level level = this.level();
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    if (this.getBehaviorState() == 5 && !list.isEmpty()) {
                        for (BlockPos pos : list) {
                            Vec3 angle = this.position().add((double)(-pos.getX()) - 0.5, (double)(-pos.getY()) - 1.0, (double)(-pos.getZ()) - 0.5);
                            double px = (double)pos.getX() + 0.5;
                            double py = (double)pos.getY() + 1.0;
                            double pz = (double)pos.getZ() + 0.5;
                            for (int i = 0; i < 10; ++i) {
                                double dx = angle.x();
                                double dy = angle.y();
                                double dz = angle.z();
                                double spread = 5.0 + (double)this.getRandom().nextFloat() * 2.5;
                                double velocity = (3.0 + (double)this.getRandom().nextFloat() * 0.15) / 45.0;
                                dx += this.getRandom().nextGaussian() * 0.0075 * spread;
                                dy += this.getRandom().nextGaussian() * 0.0075 * spread;
                                dz += this.getRandom().nextGaussian() * 0.0075 * spread;
                                ESPlatform.INSTANCE.sendToTrackingClients(serverLevel, (Entity)this, new ParticlePacket((ParticleOptions)ESParticles.ENERGY.get(), px, py, pz, dx *= velocity, dy *= velocity, dz *= velocity));
                            }
                        }
                    }
                }
                this.hasProtection = this.getBehaviorState() == 5 ? !this.getNearbyEnergyBlocks(true).isEmpty() : true;
                if (this.getPhase() != 1) break block12;
                this.hasProtection = false;
                if (this.tickCount % 60 == 0) {
                    this.hurt(this.damageSources().generic(), 0.0f);
                }
                for (BlockPos pos : ESBlockUtil.getBlocksInBoundingBox(this.getBoundingBox().inflate(3.0))) {
                    if (!(pos.distToCenterSqr((Position)this.position()) < (double)(this.getBbWidth() * this.getBbWidth() * 2.0f)) || !this.level().getBlockState(pos).is(Blocks.LAVA) || !ESPlatform.INSTANCE.postEntityDestroyBlockEvent(this.level(), pos, (Entity)this)) continue;
                    this.level().setBlockAndUpdate(pos, Blocks.MAGMA_BLOCK.defaultBlockState());
                    Level level2 = this.level();
                    if (!(level2 instanceof ServerLevel)) continue;
                    ServerLevel serverLevel = (ServerLevel)level2;
                    serverLevel.sendParticles((ParticleOptions)ESExplosionParticleOptions.LAVA, pos.getCenter().x, pos.getCenter().y + 0.6, pos.getCenter().z, 1, 0.0, 0.0, 0.0, 0.0);
                }
                break block12;
            }
            if (this.getRandom().nextInt(Mth.clamp((int)Math.round(this.getHealth() / this.getMaxHealth() * 30.0f), (int)1, (int)30)) == 0) {
                Vec3 smokePos = this.position().add((double)(this.getBbWidth() * (this.getRandom().nextFloat() - 0.5f)), (double)(this.getBbHeight() * this.getRandom().nextFloat()), (double)(this.getBbWidth() * (this.getRandom().nextFloat() - 0.5f)));
                this.level().addParticle((ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, smokePos.x, smokePos.y, smokePos.z, 0.0, (double)this.getRandom().nextFloat() * 0.15, 0.0);
            }
            if (this.getRandom().nextInt(3) == 0 && this.getPhase() == 1) {
                Vec3 sparkPos = this.position().add((double)(this.getBbWidth() * (this.getRandom().nextFloat() - 0.5f)), (double)(this.getBbHeight() * this.getRandom().nextFloat()), (double)(this.getBbWidth() * (this.getRandom().nextFloat() - 0.5f)));
                for (int i = 0; i < 25; ++i) {
                    Vec3 speed = new Vec3((double)((this.random.nextFloat() - this.random.nextFloat()) * 0.1f), (double)(this.random.nextFloat() * 0.05f), (double)((this.random.nextFloat() - this.random.nextFloat()) * 0.1f)).normalize();
                    this.level().addParticle((ParticleOptions)ExplosionShockParticleOptions.ENERGY_SMALL, sparkPos.x, sparkPos.y, sparkPos.z, speed.x, speed.y, speed.z);
                }
            }
        }
    }

    @Override
    public void dropExtraLoot(ServerPlayer player) {
        ESCrestUtil.upgradeCrest((Player)player, ESCrests.BLAZING_BEAM);
    }

    @Override
    public SoundEvent getBossMusic() {
        return ESSoundEvents.MUSIC_BOSS_STARLIGHT_GOLEM.get();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return ESSoundEvents.STARLIGHT_GOLEM_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return ESSoundEvents.STARLIGHT_GOLEM_DEATH.get();
    }

    private class GolemLookAtTargetGoal
    extends LookAtTargetGoal {
        public GolemLookAtTargetGoal() {
            super((Mob)StarlightGolem.this);
        }

        @Override
        public void tick() {
            boolean affectsLook;
            boolean bl = affectsLook = StarlightGolem.this.getBehaviorState() == 1 || StarlightGolem.this.getBehaviorState() == 3 && StarlightGolem.this.getBehaviorTicks() > 30;
            if (!affectsLook) {
                super.tick();
            }
        }
    }
}

