/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.model.entity;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.client.model.animation.AnimatedEntityModel;
import cn.leolezury.eternalstarlight.common.client.model.animation.definition.LuminoFishAnimation;
import cn.leolezury.eternalstarlight.common.entity.living.animal.Luminofish;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class LuminoFishModel<T extends Luminofish>
extends AnimatedEntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(EternalStarlight.id("luminofish"), "main");
    private final ModelPart head;

    public LuminoFishModel(ModelPart root) {
        this.head = root.getChild("head");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, -3.0f, -4.0f, 6.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        head.addOrReplaceChild("head_swell", CubeListBuilder.create().texOffs(0, 9).addBox(-2.0f, -3.5f, -4.5f, 4.0f, 3.0f, 5.0f, new CubeDeformation(0.1f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition body = head.addOrReplaceChild("body", CubeListBuilder.create().texOffs(15, 14).addBox(-1.0f, -1.0f, -0.4f, 2.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-1.5f, (float)1.0f));
        body.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(10, 9).addBox(-3.0f, 0.0f, 0.0f, 6.0f, 0.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)2.0f));
        head.addOrReplaceChild("left_fin", CubeListBuilder.create().texOffs(0, 0).addBox(-0.1f, 0.0f, -1.0f, 2.0f, 0.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.5f, (float)-1.0f, (float)-1.0f));
        head.addOrReplaceChild("right_fin", CubeListBuilder.create().texOffs(0, 2).addBox(-1.9f, 0.0f, -1.0f, 2.0f, 0.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.5f, (float)-1.0f, (float)-1.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.animate(((Luminofish)((Object)entity)).swimAnimationState, LuminoFishAnimation.SWIM, ageInTicks, 1.0f, entity.isInWater() ? 1.0f : 1.5f);
        if (((Luminofish)((Object)entity)).getSwellTicks() > 0) {
            this.animate(((Luminofish)((Object)entity)).swellAnimationState, LuminoFishAnimation.SWELL, ageInTicks);
        }
    }

    @Override
    public ModelPart root() {
        return this.head;
    }
}

