/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ESMossBlock
extends Block
implements BonemealableBlock {
    private final ResourceKey<ConfiguredFeature<?, ?>> bonemealFeature;
    private final Optional<Holder<ParticleType<?>>> fallingParticle;
    public static final MapCodec<ESMossBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceKey.codec((ResourceKey)Registries.CONFIGURED_FEATURE).fieldOf("bonemeal_feature").forGetter(block -> block.bonemealFeature), (App)BuiltInRegistries.PARTICLE_TYPE.holderByNameCodec().optionalFieldOf("falling_particle").forGetter(block -> block.fallingParticle), (App)ESMossBlock.propertiesCodec()).apply((Applicative)instance, ESMossBlock::new));

    public MapCodec<ESMossBlock> codec() {
        return CODEC;
    }

    public ESMossBlock(ResourceKey<ConfiguredFeature<?, ?>> bonemealFeature, Holder<ParticleType<?>> fallingParticle, BlockBehaviour.Properties properties) {
        this(bonemealFeature, Optional.of(fallingParticle), properties);
    }

    public ESMossBlock(ResourceKey<ConfiguredFeature<?, ?>> bonemealFeature, Optional<Holder<ParticleType<?>>> fallingParticle, BlockBehaviour.Properties properties) {
        super(properties);
        this.bonemealFeature = bonemealFeature;
        this.fallingParticle = fallingParticle;
    }

    public boolean isValidBonemealTarget(LevelReader levelReader, BlockPos blockPos, BlockState blockState) {
        return levelReader.getBlockState(blockPos.above()).isAir();
    }

    public boolean isBonemealSuccess(Level level, RandomSource randomSource, BlockPos blockPos, BlockState blockState) {
        return true;
    }

    public void performBonemeal(ServerLevel serverLevel, RandomSource randomSource, BlockPos blockPos, BlockState blockState) {
        serverLevel.registryAccess().registry(Registries.CONFIGURED_FEATURE).flatMap(registry -> registry.getHolder(this.bonemealFeature)).ifPresent(reference -> ((ConfiguredFeature)reference.value()).place((WorldGenLevel)serverLevel, serverLevel.getChunkSource().getGenerator(), randomSource, blockPos.above()));
    }

    public BonemealableBlock.Type getType() {
        return BonemealableBlock.Type.NEIGHBOR_SPREADER;
    }

    public void animateTick(BlockState blockState, Level level, BlockPos blockPos, RandomSource randomSource) {
        super.animateTick(blockState, level, blockPos, randomSource);
        Object var6_5 = this.fallingParticle.map(Holder::value).orElse(null);
        if (var6_5 instanceof SimpleParticleType) {
            BlockPos blockPos2;
            BlockState blockState2;
            SimpleParticleType type = var6_5;
            if (randomSource.nextInt(10) == 0 && !ESMossBlock.isFaceFull((VoxelShape)(blockState2 = level.getBlockState(blockPos2 = blockPos.below())).getCollisionShape((BlockGetter)level, blockPos2), (Direction)Direction.UP)) {
                ParticleUtils.spawnParticleBelow((Level)level, (BlockPos)blockPos, (RandomSource)randomSource, (ParticleOptions)type);
            }
        }
    }
}

