/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features.features.property_reading.properties.etf_properties;

import java.util.Properties;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import traben.entity_texture_features.features.property_reading.properties.RandomProperty;
import traben.entity_texture_features.features.property_reading.properties.generic_properties.BooleanProperty;
import traben.entity_texture_features.features.state.ETFEntityRenderState;
import traben.entity_texture_features.utils.ETFEntity;

public class CreativeProperty
extends BooleanProperty {
    protected CreativeProperty(Properties properties, int propertyNum) throws RandomProperty.RandomPropertyException {
        super(CreativeProperty.getGenericBooleanThatCanNull(properties, propertyNum, "isCreative", "creative"));
    }

    public static CreativeProperty getPropertyOrNull(Properties properties, int propertyNum) {
        try {
            return new CreativeProperty(properties, propertyNum);
        }
        catch (RandomProperty.RandomPropertyException e) {
            return null;
        }
    }

    @Override
    @Nullable
    protected Boolean getValueFromEntity(ETFEntityRenderState etfEntity) {
        ETFEntity eTFEntity;
        if (etfEntity != null && (eTFEntity = etfEntity.entity()) instanceof Player) {
            Player player = (Player)eTFEntity;
            return player.isCreative();
        }
        return null;
    }

    @Override
    @NotNull
    public String[] getPropertyIds() {
        return new String[]{"isCreative", "creative"};
    }
}

