/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features.config.screens.skin;

import com.mojang.blaze3d.platform.NativeImage;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.renderer.texture.HttpTexture;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import traben.entity_texture_features.ETF;
import traben.entity_texture_features.config.screens.skin.ETFScreenOldCompat;
import traben.entity_texture_features.features.ETFManager;
import traben.entity_texture_features.utils.ETFUtils2;

public class ETFConfigScreenSkinToolOutcome
extends ETFScreenOldCompat {
    private final boolean didSucceed;
    private final NativeImage skin;

    protected ETFConfigScreenSkinToolOutcome(Screen parent, boolean success, NativeImage skin) {
        super("config.entity_texture_features.player_skin_editor.print_skin.result", parent, false);
        this.didSucceed = success;
        this.skin = skin;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean uploadSkin(boolean skinType) {
        try (CloseableHttpClient httpClient = HttpClientBuilder.create().build();){
            if ("127.0.0.1".equals(InetAddress.getLocalHost().getHostAddress())) {
                boolean bl2 = false;
                return bl2;
            }
            String auth = Minecraft.getInstance().getUser().getAccessToken();
            HttpPost http = new HttpPost("https://api.minecraftservices.com/minecraft/profile/skins");
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            builder.addTextBody("variant", skinType ? "classic" : "slim", ContentType.TEXT_PLAIN);
            assert (ETF.getConfigDirectory() != null);
            builder.addBinaryBody("file", (InputStream)new FileInputStream(Path.of(ETF.getConfigDirectory().toFile().getParent(), "\\ETF_player_skin_printout.png").toFile()), ContentType.IMAGE_PNG, "skin.png");
            http.setEntity(builder.build());
            http.addHeader("Authorization", "Bearer " + auth);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)http);
            boolean bl = response.getStatusLine().getStatusCode() == 200;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    protected void init() {
        super.init();
        this.addRenderableWidget((GuiEventListener)this.getETFButton((int)((double)this.width * 0.55), (int)((double)this.height * 0.9), (int)((double)this.width * 0.2), 20, CommonComponents.GUI_DONE, button -> Objects.requireNonNull(this.minecraft).setScreen(this.parent)));
        if (this.didSucceed) {
            this.addRenderableWidget((GuiEventListener)this.getETFButton((int)((double)this.width * 0.15), (int)((double)this.height * 0.6), (int)((double)this.width * 0.7), 20, ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.print_skin.open"), button -> {
                try {
                    assert (ETF.getConfigDirectory() != null);
                    Path outputDirectory = Path.of(ETF.getConfigDirectory().toFile().getParent(), new String[0]);
                    Util.getPlatform().openFile(outputDirectory.toFile());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }));
            this.addRenderableWidget((GuiEventListener)this.getETFButton((int)((double)this.width * 0.15), (int)((double)this.height * 0.4), (int)((double)this.width * 0.7), 20, ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.upload_skin"), button -> {
                boolean changeSuccess;
                PlayerInfo playerListEntry;
                if (Minecraft.getInstance().player == null) {
                    return;
                }
                boolean skinType = true;
                if (Minecraft.getInstance().getConnection() != null && (playerListEntry = Minecraft.getInstance().getConnection().getPlayerInfo(Minecraft.getInstance().player.getUUID())) != null) {
                    skinType = Minecraft.getInstance().getSkinManager().getInsecureSkin(playerListEntry.getProfile()).model() == PlayerSkin.Model.WIDE;
                }
                button.setMessage(ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.upload_skin_v2." + ((changeSuccess = ETFConfigScreenSkinToolOutcome.uploadSkin(skinType)) ? "success" : "fail")));
                if (changeSuccess) {
                    HttpTexture skinfile = (HttpTexture)Minecraft.getInstance().getSkinManager().skinTextures.textureManager.getTexture(Minecraft.getInstance().player.getSkin().texture(), null);
                    try {
                        assert (skinfile.file != null);
                        this.skin.writeToFile(skinfile.file);
                    }
                    catch (IOException e) {
                        ETFUtils2.logError(ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.upload_skin.success_local_fail").getString(), true);
                    }
                    if (Minecraft.getInstance().player != null) {
                        ETFManager.getInstance().PLAYER_TEXTURE_MAP.removeEntryOnly(Minecraft.getInstance().player.getUUID());
                    }
                } else {
                    ETFUtils2.logError("Failed to change in-game skin correctly, you might need to restart to see all the uploaded changes in-game", true);
                }
                button.active = false;
            }));
        }
    }

    @Override
    public void render(GuiGraphics context, int mouseX, int mouseY, float delta) {
        super.render(context, mouseX, mouseY, delta);
        String[] strings = ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.print_skin.result." + (this.didSucceed ? "success" : "fail")).getString().split("\n");
        ArrayList<Component> lines = new ArrayList<Component>();
        for (String str : strings) {
            lines.add(Component.nullToEmpty((String)str.strip()));
        }
        int i = 0;
        for (Component txt : lines) {
            context.drawCenteredString(this.font, txt.getVisualOrderText(), (int)((double)this.width * 0.5), (int)((double)this.height * 0.3) + i, 0xFFFFFF);
            i += txt.getString().isBlank() ? 5 : 10;
        }
    }
}

