/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.models.animation.math.methods.emf;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.Mth;
import traben.entity_model_features.models.animation.EMFAnimation;
import traben.entity_model_features.models.animation.math.EMFMathException;
import traben.entity_model_features.models.animation.math.MathComponent;
import traben.entity_model_features.models.animation.math.MathMethod;
import traben.entity_model_features.models.animation.math.MathValue;

public class KeyframeloopMethod
extends MathMethod {
    public KeyframeloopMethod(List<String> args, boolean isNegative, EMFAnimation calculationInstance) throws EMFMathException {
        super(isNegative, calculationInstance, args.size());
        List<MathComponent> parsedArgs = KeyframeloopMethod.parseAllArgs(args, calculationInstance);
        MathComponent delta = parsedArgs.get(0);
        ArrayList<MathComponent> frames = new ArrayList<MathComponent>(parsedArgs.subList(1, parsedArgs.size()));
        MathComponent[] frameArray = frames.toArray(new MathComponent[0]);
        int frameCount = frameArray.length;
        MathValue.ResultSupplier supplier = () -> {
            float deltaRaw = delta.getResult();
            int deltaFloor = Mth.floor((float)deltaRaw);
            MathComponent baseFrame = frameArray[(deltaFloor % frameCount + frameCount) % frameCount];
            MathComponent beforeFrame = frameArray[((deltaFloor - 1) % frameCount + frameCount) % frameCount];
            MathComponent nextFrame = frameArray[((deltaFloor + 1) % frameCount + frameCount) % frameCount];
            MathComponent afterFrame = frameArray[((deltaFloor + 2) % frameCount + frameCount) % frameCount];
            float individualFrameDelta = Mth.frac((float)deltaRaw);
            return Mth.catmullrom((float)individualFrameDelta, (float)beforeFrame.getResult(), (float)baseFrame.getResult(), (float)nextFrame.getResult(), (float)afterFrame.getResult());
        };
        if (delta.isConstant()) {
            float deltaRaw = delta.getResult();
            int deltaFloor = Mth.floor((float)deltaRaw);
            MathComponent baseFrame = frameArray[(deltaFloor % frameCount + frameCount) % frameCount];
            MathComponent beforeFrame = frameArray[((deltaFloor - 1) % frameCount + frameCount) % frameCount];
            MathComponent nextFrame = frameArray[((deltaFloor + 1) % frameCount + frameCount) % frameCount];
            MathComponent afterFrame = frameArray[((deltaFloor + 2) % frameCount + frameCount) % frameCount];
            float individualFrameDelta = Mth.frac((float)deltaRaw);
            this.setOptimizedAlternativeToThis(() -> Mth.catmullrom((float)individualFrameDelta, (float)beforeFrame.getResult(), (float)baseFrame.getResult(), (float)nextFrame.getResult(), (float)afterFrame.getResult()));
        }
        this.setSupplierAndOptimize(supplier, parsedArgs);
    }

    @Override
    protected boolean hasCorrectArgCount(int argCount) {
        return argCount >= 3;
    }
}

