/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.entangled;

import com.mojang.blaze3d.vertex.PoseStack;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.block.BaseBlock;
import com.supermartijn642.core.registry.ClientRegistrationHandler;
import com.supermartijn642.core.render.CustomRendererBakedModelWrapper;
import com.supermartijn642.core.render.RenderUtils;
import com.supermartijn642.core.render.RenderWorldEvent;
import com.supermartijn642.entangled.Entangled;
import com.supermartijn642.entangled.EntangledBinderItem;
import com.supermartijn642.entangled.EntangledBlockEntity;
import com.supermartijn642.entangled.EntangledBlockEntityRenderer;
import com.supermartijn642.entangled.EntangledBlockItemRenderer;
import com.supermartijn642.entangled.EntangledConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderHighlightEvent;

public class EntangledClient {
    public static void register() {
        ClientRegistrationHandler handler = ClientRegistrationHandler.get((String)"entangled");
        handler.registerCustomBlockEntityRenderer(() -> Entangled.tile, EntangledBlockEntityRenderer::new);
        handler.registerCustomItemRenderer(() -> Entangled.block.asItem(), EntangledBlockItemRenderer::new);
        handler.registerModelOverwrite("entangled", "block", "inventory", CustomRendererBakedModelWrapper::wrap);
        handler.registerBlockModelCutoutRenderType(() -> Entangled.block);
    }

    @EventBusSubscriber(value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.GAME)
    public static class Events {
        @SubscribeEvent
        public static void onDrawPlayerEvent(RenderWorldEvent e) {
            EntangledBinderItem.BinderTarget target;
            ItemStack stack = ClientUtils.getPlayer().getItemInHand(InteractionHand.MAIN_HAND);
            Level world = ClientUtils.getWorld();
            if (stack.getItem() instanceof BlockItem && ((BlockItem)stack.getItem()).getBlock() == Entangled.block && stack.get(BaseBlock.TILE_DATA) != null) {
                CompoundTag compound = (CompoundTag)stack.get(BaseBlock.TILE_DATA);
                if (compound.getBoolean("bound") && compound.getString("dimension").equals(world.dimension().location().toString())) {
                    BlockPos pos = new BlockPos(compound.getInt("boundx"), compound.getInt("boundy"), compound.getInt("boundz"));
                    e.getPoseStack().pushPose();
                    Vec3 camera = RenderUtils.getCameraPosition();
                    e.getPoseStack().translate(-camera.x, -camera.y, -camera.z);
                    e.getPoseStack().translate((float)pos.getX(), (float)pos.getY(), (float)pos.getZ());
                    RenderUtils.renderShape((PoseStack)e.getPoseStack(), (VoxelShape)world.getBlockState(pos).getOcclusionShape((BlockGetter)world, pos), (float)0.3372549f, (float)0.0f, (float)0.6117647f, (boolean)false);
                    RenderUtils.renderShapeSides((PoseStack)e.getPoseStack(), (VoxelShape)world.getBlockState(pos).getOcclusionShape((BlockGetter)world, pos), (float)0.3372549f, (float)0.0f, (float)0.6117647f, (float)0.11764706f, (boolean)false);
                    e.getPoseStack().popPose();
                }
            } else if (stack.getItem() == Entangled.item && (target = (EntangledBinderItem.BinderTarget)stack.get(EntangledBinderItem.BINDER_TARGET)) != null && target.dimension().equals((Object)world.dimension().location())) {
                BlockPos pos = target.pos();
                e.getPoseStack().pushPose();
                Vec3 camera = RenderUtils.getCameraPosition();
                e.getPoseStack().translate(-camera.x, -camera.y, -camera.z);
                e.getPoseStack().translate((float)pos.getX(), (float)pos.getY(), (float)pos.getZ());
                RenderUtils.renderShape((PoseStack)e.getPoseStack(), (VoxelShape)world.getBlockState(pos).getOcclusionShape((BlockGetter)world, pos), (float)0.92156863f, (float)0.8235294f, (float)0.20392157f, (boolean)false);
                RenderUtils.renderShapeSides((PoseStack)e.getPoseStack(), (VoxelShape)world.getBlockState(pos).getOcclusionShape((BlockGetter)world, pos), (float)0.92156863f, (float)0.8235294f, (float)0.20392157f, (float)0.11764706f, (boolean)false);
                e.getPoseStack().popPose();
            }
        }

        @SubscribeEvent
        public static void onBlockHighlight(RenderHighlightEvent.Block e) {
            if (e.getTarget().getType() != HitResult.Type.BLOCK || e.getTarget().getBlockPos() == null || !EntangledConfig.renderBlockHighlight.get().booleanValue()) {
                return;
            }
            ClientLevel world = Minecraft.getInstance().level;
            BlockEntity tile = world.getBlockEntity(e.getTarget().getBlockPos());
            if (tile instanceof EntangledBlockEntity && ((EntangledBlockEntity)tile).isBound() && ((EntangledBlockEntity)tile).getBoundDimensionIdentifier() == world.dimension()) {
                BlockPos pos = ((EntangledBlockEntity)tile).getBoundBlockPos();
                e.getPoseStack().pushPose();
                Vec3 camera = RenderUtils.getCameraPosition();
                e.getPoseStack().translate(-camera.x, -camera.y, -camera.z);
                e.getPoseStack().translate((float)pos.getX(), (float)pos.getY(), (float)pos.getZ());
                RenderUtils.renderShape((PoseStack)e.getPoseStack(), (VoxelShape)world.getBlockState(pos).getOcclusionShape((BlockGetter)world, pos), (float)0.3372549f, (float)0.0f, (float)0.6117647f, (boolean)false);
                RenderUtils.renderShapeSides((PoseStack)e.getPoseStack(), (VoxelShape)world.getBlockState(pos).getOcclusionShape((BlockGetter)world, pos), (float)0.3372549f, (float)0.0f, (float)0.6117647f, (float)0.11764706f, (boolean)false);
                e.getPoseStack().popPose();
            }
        }
    }
}

