/*
 * Decompiled with CFR 0.152.
 */
package com.sts15.enderdrives.network.packet;

import com.sts15.enderdrives.db.ClientDiskCache;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record UpdateDiskTypeCountPacket(String scopePrefix, int frequency, int typeCount, int typeLimit, long totalItemCount, List<ItemStack> topStacks) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<UpdateDiskTypeCountPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"enderdrives", (String)"update_disk_type_count"));
    public static final StreamCodec<RegistryFriendlyByteBuf, UpdateDiskTypeCountPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, UpdateDiskTypeCountPacket::scopePrefix, (StreamCodec)ByteBufCodecs.VAR_INT, UpdateDiskTypeCountPacket::frequency, (StreamCodec)ByteBufCodecs.VAR_INT, UpdateDiskTypeCountPacket::typeCount, (StreamCodec)ByteBufCodecs.VAR_INT, UpdateDiskTypeCountPacket::typeLimit, (StreamCodec)ByteBufCodecs.VAR_LONG, UpdateDiskTypeCountPacket::totalItemCount, (StreamCodec)ItemStack.STREAM_CODEC.apply(ByteBufCodecs.list()), UpdateDiskTypeCountPacket::topStacks, UpdateDiskTypeCountPacket::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(UpdateDiskTypeCountPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            String key = packet.scopePrefix() + "|" + packet.frequency();
            ClientDiskCache.update(key, packet.typeCount(), packet.typeLimit(), packet.totalItemCount(), packet.topStacks());
        });
    }
}

