/*
 * Decompiled with CFR 0.152.
 */
package com.sts15.enderdrives.db;

import com.sts15.enderdrives.db.DiskTypeInfo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.world.item.ItemStack;

public class ClientDiskCache {
    private static final Map<String, DiskTypeInfo> DISK_CACHE = new HashMap<String, DiskTypeInfo>();

    public static void update(String key, int typeCount, int typeLimit, long totalItemCount, List<ItemStack> topStacks) {
        DISK_CACHE.put(key, new DiskTypeInfo(typeCount, typeLimit, totalItemCount, topStacks));
    }

    public static DiskTypeInfo get(String key) {
        return DISK_CACHE.getOrDefault(key, new DiskTypeInfo(0, 0, 0L, List.of()));
    }

    public static List<ItemStack> getTopStacks(String scopePrefix, int frequency) {
        return ClientDiskCache.get(scopePrefix + "|" + frequency).topStacks();
    }

    public static boolean isEmpty(String scopePrefix, int frequency) {
        return ClientDiskCache.getTopStacks(scopePrefix, frequency).isEmpty();
    }

    public static boolean shouldRequest(String key) {
        return !DISK_CACHE.containsKey(key);
    }
}

