/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.server.serializer;

import dev.kosmx.playerAnim.core.data.AnimationFormat;
import dev.kosmx.playerAnim.core.data.KeyframeAnimation;
import dev.kosmx.playerAnim.core.util.MathHelper;
import dev.kosmx.playerAnim.core.util.UUIDMap;
import io.github.kosmx.emotes.executor.EmoteInstance;
import io.github.kosmx.emotes.server.serializer.EmoteSerializer;
import io.github.kosmx.emotes.server.serializer.type.BinaryFormat;
import io.github.kosmx.emotes.server.serializer.type.EmoteSerializerException;
import io.github.kosmx.emotes.server.serializer.type.IReader;
import io.github.kosmx.emotes.server.serializer.type.ISerializer;
import io.github.kosmx.emotes.server.serializer.type.JsonEmoteWrapper;
import io.github.kosmx.emotes.server.serializer.type.QuarkReaderWrapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import javax.annotation.Nullable;

public class UniversalEmoteSerializer {
    public static List<IReader> readers = Arrays.asList(new JsonEmoteWrapper(), new QuarkReaderWrapper(), new BinaryFormat());
    public static UUIDMap<KeyframeAnimation> serverEmotes = new UUIDMap();
    public static UUIDMap<KeyframeAnimation> hiddenServerEmotes = new UUIDMap();

    public static List<KeyframeAnimation> readData(InputStream inputStream, @Nullable String filename, String format) throws EmoteSerializerException {
        for (IReader reader : readers) {
            if (!reader.getFormatExtension().equals(format)) continue;
            try {
                return reader.read(inputStream, filename);
            }
            catch (EmoteSerializerException e) {
                throw e;
            }
            catch (Exception e) {
                throw new EmoteSerializerException(e.getClass().getName() + " has occurred while serializing an emote", format, e);
            }
        }
        throw new EmoteSerializerException("No known reader for format", format);
    }

    public static List<KeyframeAnimation> readData(InputStream inputStream, String filename) throws EmoteSerializerException {
        if (filename == null || filename.isEmpty()) {
            throw new IllegalArgumentException("filename can not be null if no format type was given");
        }
        String format = filename.substring(filename.lastIndexOf(".") + 1).toLowerCase();
        return UniversalEmoteSerializer.readData(inputStream, filename, format);
    }

    public static void writeKeyframeAnimation(OutputStream stream, KeyframeAnimation emote, AnimationFormat format) throws EmoteSerializerException {
        for (IReader writerCandidate : readers) {
            if (!(writerCandidate instanceof ISerializer) || writerCandidate.getFormatType() != format) continue;
            ISerializer serializer = (ISerializer)writerCandidate;
            serializer.write(emote, stream);
            return;
        }
        throw new EmoteSerializerException("No writer has been found for Format: " + format.toString(), format.getExtension());
    }

    public static void loadEmotes() {
        serverEmotes.clear();
        hiddenServerEmotes.clear();
        UniversalEmoteSerializer.serializeInternalJson("waving");
        UniversalEmoteSerializer.serializeInternalJson("clap");
        UniversalEmoteSerializer.serializeInternalJson("crying");
        UniversalEmoteSerializer.serializeInternalJson("point");
        UniversalEmoteSerializer.serializeInternalJson("here");
        UniversalEmoteSerializer.serializeInternalJson("palm");
        UniversalEmoteSerializer.serializeInternalJson("backflip");
        UniversalEmoteSerializer.serializeInternalJson("roblox_potion_dance");
        UniversalEmoteSerializer.serializeInternalJson("kazotsky_kick");
        if (!EmoteInstance.instance.getExternalEmoteDir().isDirectory()) {
            EmoteInstance.instance.getExternalEmoteDir().mkdirs();
        }
        EmoteSerializer.serializeEmotes(EmoteInstance.config.loadEmotesServerSide.get() != false ? serverEmotes : hiddenServerEmotes, EmoteInstance.instance.getExternalEmoteDir().toPath());
        Path serverEmotesDir = EmoteInstance.instance.getExternalEmoteDir().toPath().resolve("server");
        if (Files.isDirectory(serverEmotesDir, new LinkOption[0])) {
            EmoteSerializer.serializeEmotes(serverEmotes, serverEmotesDir);
        }
    }

    private static void serializeInternalJson(String name) {
        if (!EmoteInstance.config.loadBuiltinEmotes.get().booleanValue()) {
            return;
        }
        try (InputStream stream = UniversalEmoteSerializer.class.getResourceAsStream("/assets/emotecraft/emotes/" + name + ".json");){
            List<KeyframeAnimation> emotes = UniversalEmoteSerializer.readData(stream, null, "json");
            KeyframeAnimation emote = emotes.getFirst();
            emote.extraData.put("isBuiltin", true);
            InputStream iconStream = UniversalEmoteSerializer.class.getResourceAsStream("/assets/emotecraft/emotes/" + name + ".png");
            if (iconStream != null) {
                emote.extraData.put("iconData", MathHelper.readFromIStream((InputStream)iconStream));
                iconStream.close();
            }
            hiddenServerEmotes.addAll(emotes);
        }
        catch (EmoteSerializerException | IOException e) {
            EmoteInstance.instance.getLogger().log(Level.WARNING, e.getMessage(), e);
        }
    }

    public static KeyframeAnimation getEmote(UUID uuid) {
        KeyframeAnimation ret = (KeyframeAnimation)serverEmotes.get((Object)uuid);
        if (ret != null) {
            return ret;
        }
        return (KeyframeAnimation)hiddenServerEmotes.get((Object)uuid);
    }
}

