/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.main.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import io.github.kosmx.emotes.executor.EmoteInstance;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import java.util.logging.Level;
import javax.annotation.Nullable;

public class EmoteFixer {
    private final int currentVersion;
    @Nullable
    private JsonElement data = null;

    public EmoteFixer(int version) {
        this.currentVersion = version;
    }

    public UUID getEmoteID(JsonElement element) {
        try {
            int id = 0;
            UUID uuid = null;
            if (this.currentVersion < 4) {
                id = element.getAsInt();
            } else {
                uuid = UUID.fromString(element.getAsString());
            }
            for (int i = this.currentVersion; i < 4; ++i) {
                if (!this.getData().has(Integer.toString(i))) continue;
                if (i < 3) {
                    if (!this.getData().get(Integer.toString(i)).getAsJsonObject().has(String.valueOf(id))) continue;
                    id = this.getData().get(String.valueOf(i)).getAsJsonObject().get(String.valueOf(id)).getAsInt();
                    continue;
                }
                if (i == 3) {
                    if (!this.getData().get(Integer.toString(i)).getAsJsonObject().has(String.valueOf(id))) continue;
                    uuid = UUID.fromString(this.getData().get(String.valueOf(i)).getAsJsonObject().get(String.valueOf(id)).getAsString());
                    continue;
                }
                if (!this.getData().get(Integer.toString(i)).getAsJsonObject().has(String.valueOf(uuid))) continue;
                uuid = UUID.fromString(this.getData().get(String.valueOf(i)).getAsJsonObject().get(String.valueOf(uuid)).getAsString());
            }
            return uuid;
        }
        catch (Exception e) {
            if (element.getAsJsonPrimitive().isNumber()) {
                return new UUID(0L, 0L);
            }
            return UUID.fromString(element.getAsString());
        }
    }

    private JsonObject getData() {
        if (this.data == null) {
            try {
                InputStream stream = EmoteFixer.class.getResourceAsStream("/assets/emotecraft/emote_upgrade_data.json");
                InputStreamReader streamReader = new InputStreamReader(stream, StandardCharsets.UTF_8);
                BufferedReader reader = new BufferedReader(streamReader);
                this.data = new JsonParser().parse((Reader)reader);
            }
            catch (JsonParseException | NullPointerException e) {
                EmoteInstance.instance.getLogger().log(Level.WARNING, e.getMessage(), e);
            }
        }
        return this.data.getAsJsonObject();
    }
}

