/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.common.network;

import java.nio.Buffer;
import java.nio.ByteBuffer;

public abstract class EmoteStreamHelper {
    protected ByteBuffer receiveStream = null;

    protected abstract int getMaxPacketSize();

    protected abstract void sendPlayPacket(ByteBuffer var1);

    protected abstract void sendStreamChunk(ByteBuffer var1);

    public void sendMessage(ByteBuffer bytes) {
        if (bytes.limit() < this.getMaxPacketSize()) {
            this.sendPlayPacket(bytes);
            return;
        }
        int length = bytes.limit();
        byte[] targetArray = new byte[Math.min(this.getMaxPacketSize() - 4, bytes.remaining())];
        bytes.get(targetArray);
        ByteBuffer tmpBuffer = ByteBuffer.wrap(targetArray);
        tmpBuffer.putInt(length);
        ((Buffer)tmpBuffer).position(0);
        this.sendStreamChunk(tmpBuffer);
        while (bytes.hasRemaining()) {
            targetArray = new byte[Math.min(this.getMaxPacketSize(), bytes.remaining())];
            bytes.get(targetArray);
            this.sendStreamChunk(ByteBuffer.wrap(targetArray));
        }
    }

    public ByteBuffer receiveStream(ByteBuffer rec) {
        if (this.receiveStream == null) {
            int len = rec.getInt();
            this.receiveStream = ByteBuffer.allocate(len);
        }
        this.receiveStream.put(rec);
        if (!this.receiveStream.hasRemaining()) {
            ((Buffer)this.receiveStream).flip();
            ByteBuffer tmp = this.receiveStream;
            this.receiveStream = null;
            return tmp;
        }
        return null;
    }
}

