/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.arch.screen;

import dev.kosmx.playerAnim.core.data.AnimationFormat;
import dev.kosmx.playerAnim.core.data.KeyframeAnimation;
import io.github.kosmx.emotes.PlatformTools;
import io.github.kosmx.emotes.api.proxy.AbstractNetworkInstance;
import io.github.kosmx.emotes.arch.screen.EmoteMenu;
import io.github.kosmx.emotes.executor.EmoteInstance;
import io.github.kosmx.emotes.inline.TmpGetters;
import io.github.kosmx.emotes.main.EmoteHolder;
import io.github.kosmx.emotes.main.config.ClientConfig;
import io.github.kosmx.emotes.server.serializer.UniversalEmoteSerializer;
import io.github.kosmx.emotes.server.serializer.type.EmoteSerializerException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.logging.Level;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.HeaderAndFooterLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;

public class ExportMenu
extends Screen {
    private static final Component TITLE = Component.translatable((String)"emotecraft.options.export");
    private static final Component EXPORT_JSON = Component.translatable((String)"emotecraft.exportjson");
    private static final Component EXPORT_BIN = Component.translatable((String)"emotecraft.exportbin");
    private final HeaderAndFooterLayout layout = new HeaderAndFooterLayout((Screen)this);
    protected final Screen parent;

    public ExportMenu(Screen parent) {
        super(TITLE);
        this.parent = parent;
    }

    public void init() {
        this.layout.addTitleHeader(this.getTitle(), this.font);
        LinearLayout contents = (LinearLayout)this.layout.addToContents((LayoutElement)LinearLayout.vertical().spacing(8));
        contents.addChild((LayoutElement)Button.builder((Component)EXPORT_JSON, button -> this.exportEmotesInFormat(AnimationFormat.JSON_EMOTECRAFT)).width(200).build());
        contents.addChild((LayoutElement)Button.builder((Component)EXPORT_BIN, button -> this.exportEmotesInFormat(AnimationFormat.BINARY)).width(200).build());
        LinearLayout footer = (LinearLayout)this.layout.addToFooter((LayoutElement)LinearLayout.horizontal().spacing(8));
        footer.addChild((LayoutElement)Button.builder((Component)CommonComponents.GUI_DONE, button -> this.onClose()).build());
        footer.addChild((LayoutElement)Button.builder((Component)EmoteMenu.OPEN_FOLDER, button -> PlatformTools.openExternalEmotesDir()).build());
        this.layout.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        this.repositionElements();
    }

    private void exportEmotesInFormat(AnimationFormat format) {
        for (EmoteHolder emoteHolder : EmoteHolder.list) {
            KeyframeAnimation emote = emoteHolder.getEmote();
            if (emote.extraData.containsKey("isBuiltin") && !((ClientConfig)EmoteInstance.config).exportBuiltin.get().booleanValue()) continue;
            EmoteInstance.instance.getLogger().log(Level.FINER, "Saving " + emoteHolder.name.getString() + " into " + format.getExtension());
            try {
                Path exportDir = EmoteInstance.instance.getExternalEmoteDir().toPath().resolve(format.getExtension() + "_export");
                if (!exportDir.toFile().isDirectory()) {
                    Files.createDirectories(exportDir, new FileAttribute[0]);
                }
                Path file = ExportMenu.createFileName(emoteHolder, exportDir, format);
                OutputStream stream = Files.newOutputStream(file, new OpenOption[0]);
                UniversalEmoteSerializer.writeKeyframeAnimation(stream, emote, format);
                stream.close();
                if (format != AnimationFormat.JSON_EMOTECRAFT || !emote.extraData.containsKey("iconData")) continue;
                Path iconPath = exportDir.resolve(file.getFileName().toString().substring(0, file.getFileName().toString().lastIndexOf(".")) + ".png");
                if (iconPath.toFile().isFile()) {
                    throw new IOException("File already exists: " + String.valueOf(iconPath));
                }
                OutputStream iconStream = Files.newOutputStream(iconPath, new OpenOption[0]);
                iconStream.write(AbstractNetworkInstance.safeGetBytesFromBuffer((ByteBuffer)emote.extraData.get("iconData")));
                iconStream.close();
            }
            catch (EmoteSerializerException | IOException | InvalidPathException e) {
                EmoteInstance.instance.getLogger().log(Level.WARNING, e.getMessage(), e);
                TmpGetters.getClientMethods().toastExportMessage(2, (Component)Component.translatable((String)("emotecraft.export.error." + format.getExtension())), emoteHolder.name.getString());
            }
        }
        TmpGetters.getClientMethods().toastExportMessage(1, (Component)Component.translatable((String)("emotecraft.export.done." + format.getExtension())), "emotes/" + format.getExtension() + "_export/");
        EmoteInstance.instance.getLogger().log(Level.FINER, "All emotes are saved in " + format.getExtension() + " format", true);
    }

    private static Path createFileName(EmoteHolder emote, Path originPath, AnimationFormat format) {
        Object name = emote.name.getString().replaceAll("[\\\\/]", "#");
        String finalName = null;
        while (finalName == null) {
            try {
                originPath.resolve((String)name);
                finalName = name;
            }
            catch (InvalidPathException e) {
                int i = e.getIndex();
                name = ((String)name).substring(0, i) + "#" + ((String)name).substring(i + 1);
            }
        }
        int i = 2;
        Path file = originPath.resolve(finalName + "." + format.getExtension());
        if (!file.getParent().equals(originPath)) {
            finalName = Integer.toString(emote.hashCode());
            file = originPath.resolve(finalName + "." + format.getExtension());
        }
        while (file.toFile().isFile()) {
            file = originPath.resolve(finalName + "_" + i++ + "." + format.getExtension());
        }
        return file;
    }

    protected void repositionElements() {
        this.layout.arrangeElements();
    }

    public void onClose() {
        this.minecraft.setScreen(this.parent);
    }
}

