/*
 * Decompiled with CFR 0.152.
 */
package moe.prwk.emiffect.util;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.emi.emi.EmiPort;
import dev.emi.emi.EmiUtil;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.stack.serializer.EmiStackSerializer;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import moe.prwk.emiffect.mixin.TextureAtlasHolderInvoker;
import moe.prwk.emiffect.util.VersionUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.MobEffectTextureManager;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.effect.MobEffect;
import org.jetbrains.annotations.Nullable;

public class MobEffectEmiStack
extends EmiStack {
    private static final MutableComponent WHITESPACE = EmiPort.literal((String)" ");
    @Nullable
    private final MobEffect effect;

    public MobEffectEmiStack(@Nullable MobEffect effect) {
        this.effect = effect;
    }

    public EmiStack copy() {
        return new MobEffectEmiStack(this.effect);
    }

    public void render(GuiGraphics draw, int x, int y, float delta, int flags) {
        MobEffectTextureManager sprites = Minecraft.getInstance().getMobEffectTextures();
        if (this.effect != null) {
            TextureAtlasSprite sprite = ((TextureAtlasHolderInvoker)sprites).emiffect$invokeGetSprite(this.getId());
            RenderSystem.clearColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.setShader(GameRenderer::getPositionTexShader);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)sprite.atlasLocation());
            draw.blit(x, y, 0, 18, 18, sprite);
            RenderSystem.applyModelViewMatrix();
        }
    }

    public boolean isEmpty() {
        return this.effect == null;
    }

    public DataComponentPatch getComponentChanges() {
        return DataComponentPatch.EMPTY;
    }

    public Object getKey() {
        return this.effect;
    }

    public ResourceLocation getId() {
        if (this.effect == null) {
            return VersionUtil.identifier("emiffect", "missingno");
        }
        return BuiltInRegistries.MOB_EFFECT.getKey((Object)this.effect);
    }

    public List<Component> getTooltipText() {
        return List.of(this.getName());
    }

    public List<ClientTooltipComponent> getTooltip() {
        if (this.effect == null) {
            return List.of();
        }
        ArrayList<ClientTooltipComponent> tooltips = new ArrayList<ClientTooltipComponent>(this.getTooltipText().stream().map(EmiPort::ordered).map(ClientTooltipComponent::create).toList());
        switch (this.effect.getCategory()) {
            case BENEFICIAL: {
                tooltips.add(ClientTooltipComponent.create((FormattedCharSequence)EmiPort.ordered((Component)EmiPort.translatable((String)"tooltip.emiffect.beneficial").withStyle(ChatFormatting.GREEN))));
                break;
            }
            case NEUTRAL: {
                tooltips.add(ClientTooltipComponent.create((FormattedCharSequence)EmiPort.ordered((Component)EmiPort.translatable((String)"tooltip.emiffect.neutral").withStyle(ChatFormatting.GOLD))));
                break;
            }
            case HARMFUL: {
                tooltips.add(ClientTooltipComponent.create((FormattedCharSequence)EmiPort.ordered((Component)EmiPort.translatable((String)"tooltip.emiffect.harmful").withStyle(ChatFormatting.RED))));
            }
        }
        MutableComponent component = EmiPort.translatable((String)"tooltip.emiffect.color", (Object[])new Object[]{"#" + String.format("%02x", this.effect.getColor()).toUpperCase(Locale.ROOT)}).withStyle(ChatFormatting.GRAY).append((Component)WHITESPACE).append((Component)EmiPort.literal((String)"\u2588").withStyle(style -> style.withColor(TextColor.fromRgb((int)this.effect.getColor()))));
        tooltips.add(ClientTooltipComponent.create((FormattedCharSequence)EmiPort.ordered((Component)component)));
        ResourceLocation id = BuiltInRegistries.MOB_EFFECT.getKey((Object)this.effect);
        if (id != null) {
            tooltips.add(ClientTooltipComponent.create((FormattedCharSequence)EmiPort.ordered((Component)EmiPort.literal((String)EmiUtil.getModName((String)id.getNamespace()), (ChatFormatting[])new ChatFormatting[]{ChatFormatting.BLUE, ChatFormatting.ITALIC}))));
        }
        return tooltips;
    }

    public Component getName() {
        return this.effect != null ? this.effect.getDisplayName() : EmiPort.literal((String)"missingno");
    }

    @Nullable
    public MobEffect getEffect() {
        return this.effect;
    }

    public static class Serializer
    implements EmiStackSerializer<MobEffectEmiStack> {
        public EmiStack create(ResourceLocation id, DataComponentPatch componentChanges, long amount) {
            MobEffect effect = (MobEffect)BuiltInRegistries.MOB_EFFECT.get(id);
            if (effect != null) {
                return new MobEffectEmiStack(effect);
            }
            return EmiStack.EMPTY;
        }

        public String getType() {
            return "mob_effect";
        }
    }
}

