/*
 * Decompiled with CFR 0.152.
 */
package moe.prwk.emiffect.recipes;

import dev.emi.emi.EmiPort;
import dev.emi.emi.api.EmiApi;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.SlotWidget;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import dev.emi.emi.screen.RecipeScreen;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import moe.prwk.emiffect.EMIffectPlugin;
import moe.prwk.emiffect.mixin.RecipeScreenAccessor;
import moe.prwk.emiffect.util.MobEffectEmiStack;
import moe.prwk.emiffect.util.VersionUtil;
import moe.prwk.emiffect.util.resources.ExtraAppenderLoader;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.component.SuspiciousStewEffects;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.entity.BeaconBlockEntity;
import org.jetbrains.annotations.Nullable;

public class MobEffectInfo
implements EmiRecipe {
    private final List<EmiIngredient> inputs;
    private final List<FormattedCharSequence> desc;
    private final ResourceLocation id;
    private int inputStackRow;
    private final MobEffectEmiStack emiStack;

    public MobEffectInfo(MobEffect effect, MobEffectEmiStack emiStack) {
        this.id = emiStack.getId();
        ArrayList<EmiIngredient> inputs0 = new ArrayList<EmiIngredient>();
        BuiltInRegistries.POTION.holders().forEach(potion -> {
            for (MobEffectInstance instance : ((Potion)potion.value()).getEffects()) {
                if (!((MobEffect)instance.getEffect().value()).equals(effect)) continue;
                inputs0.addAll(List.of(EmiStack.of((ItemStack)VersionUtil.setPotion(Items.POTION.getDefaultInstance(), (Holder<Potion>)potion)), EmiStack.of((ItemStack)VersionUtil.setPotion(Items.SPLASH_POTION.getDefaultInstance(), (Holder<Potion>)potion)), EmiStack.of((ItemStack)VersionUtil.setPotion(Items.LINGERING_POTION.getDefaultInstance(), (Holder<Potion>)potion)), EmiStack.of((ItemStack)VersionUtil.setPotion(Items.TIPPED_ARROW.getDefaultInstance(), (Holder<Potion>)potion))));
                break;
            }
        });
        block0: for (Block block : BuiltInRegistries.BLOCK) {
            if (!(block instanceof FlowerBlock)) continue;
            FlowerBlock flower = (FlowerBlock)block;
            ItemStack stew = new ItemStack((ItemLike)Items.SUSPICIOUS_STEW);
            List<Holder> effects = flower.getSuspiciousEffects().effects().stream().map(SuspiciousStewEffects.Entry::effect).toList();
            for (Holder _effect2 : effects) {
                if (!((MobEffect)_effect2.value()).equals(effect)) continue;
                inputs0.add((EmiIngredient)EmiStack.of((ItemStack)stew));
                break block0;
            }
        }
        for (Item item : BuiltInRegistries.ITEM) {
            FoodProperties food = (FoodProperties)item.components().get(DataComponents.FOOD);
            if (food == null || !food.effects().stream().map(_effect -> (MobEffect)_effect.effect().getEffect().value()).toList().contains(effect)) continue;
            inputs0.add((EmiIngredient)EmiStack.of((ItemLike)item));
        }
        for (List effects : BeaconBlockEntity.BEACON_EFFECTS) {
            if (!effects.stream().map(Holder::value).toList().contains(effect)) continue;
            inputs0.add((EmiIngredient)EmiStack.of((ItemLike)Blocks.BEACON));
        }
        this.inputs = inputs0;
        this.desc = Minecraft.getInstance().font.split((FormattedText)MobEffectInfo.getDescription(this.id), 110);
        this.inputStackRow = this.inputs.isEmpty() ? 0 : 1;
        int inputColumn = 0;
        for (EmiIngredient ignored : this.inputs) {
            if (inputColumn >= 6) {
                ++this.inputStackRow;
                inputColumn = 0;
            }
            ++inputColumn;
        }
        this.emiStack = emiStack;
    }

    public void addFromAppenders(List<ExtraAppenderLoader.ExtraAppender> appenders) {
        for (ExtraAppenderLoader.ExtraAppender appender : appenders) {
            if (!this.id.equals((Object)appender.effectId())) continue;
            appender.getIngredients().forEach(ingredient -> {
                if (!this.inputs.contains(ingredient)) {
                    this.inputs.add((EmiIngredient)ingredient);
                }
            });
        }
    }

    public EmiRecipeCategory getCategory() {
        return EMIffectPlugin.CATEGORY;
    }

    @Nullable
    public ResourceLocation getId() {
        return VersionUtil.identifier("emiffect", "/effects/" + this.id.getNamespace() + "/" + this.id.getPath());
    }

    public List<EmiIngredient> getInputs() {
        return this.inputs;
    }

    public List<EmiStack> getOutputs() {
        return List.of(this.emiStack);
    }

    public int getDisplayWidth() {
        return 144;
    }

    public int getDisplayHeight() {
        int n = this.desc.size();
        Objects.requireNonNull(Minecraft.getInstance().font);
        int upperOffset = 14 + Math.max(n * 9, 30) + 2;
        int backgroundHeight = 200;
        Screen screen = Minecraft.getInstance().screen;
        if (screen instanceof RecipeScreen) {
            RecipeScreen screen2 = (RecipeScreen)screen;
            backgroundHeight = ((RecipeScreenAccessor)screen2).emiffect$getBackgroundHeight();
        }
        int slotsHeight = this.inputs.isEmpty() ? 0 : ((this.inputs.size() - 1) / 6 + 1) * 18;
        return Math.min(slotsHeight + upperOffset, backgroundHeight);
    }

    public void addWidgets(WidgetHolder widgets) {
        int titleColor = 0xFFFFFF;
        if (this.emiStack.getEffect() != null) {
            switch (this.emiStack.getEffect().getCategory()) {
                case BENEFICIAL: {
                    titleColor = ChatFormatting.GREEN.getColor();
                    break;
                }
                case NEUTRAL: {
                    titleColor = ChatFormatting.GOLD.getColor();
                    break;
                }
                case HARMFUL: {
                    titleColor = ChatFormatting.RED.getColor();
                }
            }
        }
        FormattedCharSequence title = this.emiStack.getName().getVisualOrderText();
        int titleX = 31 + (113 - Minecraft.getInstance().font.width(title)) / 2;
        widgets.addText(title, titleX, 2, titleColor, true);
        Objects.requireNonNull(Minecraft.getInstance().font);
        int lineHeight = 9;
        int descLine = 0;
        for (FormattedCharSequence text : this.desc) {
            widgets.addText(text, 31, 14 + lineHeight * descLine, 0xFFFFFF, true);
            ++descLine;
        }
        int descHeight = Math.max(descLine * lineHeight, 30);
        descHeight += 12;
        int n = this.desc.size();
        Objects.requireNonNull(Minecraft.getInstance().font);
        int upperOffset = 14 + Math.max(n * 9, 30) + 2;
        int ph = this.inputs.isEmpty() ? 0 : (widgets.getHeight() - (upperOffset + 14) - 2) / 18 + 1;
        PageManager manager = new PageManager(this.inputs, 6 * ph);
        if (ph < this.inputStackRow) {
            widgets.addButton(2, upperOffset, 12, 12, 0, 0, () -> true, (mouseX, mouseY, button) -> manager.scroll(-1));
            widgets.addButton(widgets.getWidth() - 14, upperOffset, 12, 12, 12, 0, () -> true, (mouseX, mouseY, button) -> manager.scroll(1));
        }
        for (int i = 0; i < manager.pageSize; ++i) {
            widgets.add((Widget)new PageSlotWidget(manager, i, i % 6 * 18 + 18, i / 6 * 18 + upperOffset));
        }
        SlotWidget effectSlot = new SlotWidget((EmiIngredient)this.emiStack, 3, (descHeight - 26) / 2).large(true).recipeContext((EmiRecipe)this);
        widgets.add((Widget)effectSlot);
    }

    public boolean supportsRecipeTree() {
        return false;
    }

    private static MutableComponent getDescription(ResourceLocation id) {
        String firstKey = String.format("effect.%s.%s.description", id.getNamespace(), id.getPath());
        if (I18n.exists((String)firstKey)) {
            return EmiPort.translatable((String)firstKey);
        }
        String secondKey = String.format("effect.%s.%s.desc", id.getNamespace(), id.getPath());
        if (I18n.exists((String)secondKey)) {
            return EmiPort.translatable((String)secondKey);
        }
        return EmiPort.translatable((String)"info.emiffect.desc_not_found");
    }

    private static class PageManager {
        public final List<EmiIngredient> stacks;
        public final int pageSize;
        public int currentPage;

        public PageManager(List<EmiIngredient> stacks, int pageSize) {
            this.stacks = stacks;
            this.pageSize = pageSize;
        }

        public void scroll(int delta) {
            this.currentPage += delta;
            int totalPages = (this.stacks.size() - 1) / this.pageSize + 1;
            if (this.currentPage < 0) {
                this.currentPage = totalPages - 1;
            }
            if (this.currentPage >= totalPages) {
                this.currentPage = 0;
            }
        }

        public EmiIngredient getStack(int offset) {
            if ((offset += this.pageSize * this.currentPage) < this.stacks.size()) {
                return this.stacks.get(offset);
            }
            return EmiStack.EMPTY;
        }

        public EmiRecipe getRecipe(int offset) {
            if ((offset += this.pageSize * this.currentPage) < this.stacks.size()) {
                return EmiApi.getRecipeContext((EmiIngredient)this.stacks.get(offset));
            }
            return null;
        }
    }

    private static class PageSlotWidget
    extends SlotWidget {
        public final PageManager manager;
        public final int offset;

        public PageSlotWidget(PageManager manager, int offset, int x, int y) {
            super((EmiIngredient)EmiStack.EMPTY, x, y);
            this.manager = manager;
            this.offset = offset;
        }

        public EmiIngredient getStack() {
            return this.manager.getStack(this.offset);
        }

        public EmiRecipe getRecipe() {
            return this.manager.getRecipe(this.offset);
        }

        public void render(GuiGraphics draw, int mouseX, int mouseY, float delta) {
            if (!this.getStack().isEmpty()) {
                super.render(draw, mouseX, mouseY, delta);
            }
        }
    }
}

