/*
 * Decompiled with CFR 0.152.
 */
package fzzyhmstrs.emi_loot.parser;

import fzzyhmstrs.emi_loot.EMILoot;
import fzzyhmstrs.emi_loot.parser.ItemSubPredicateParser;
import fzzyhmstrs.emi_loot.parser.LootTableParser;
import fzzyhmstrs.emi_loot.parser.processor.ListProcessors;
import fzzyhmstrs.emi_loot.util.LText;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.ItemSubPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.DataComponentPredicate;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;

public class ItemPredicateParser {
    public static Component parseItemPredicate(ItemPredicate predicate) {
        DataComponentPredicate componentPredicate;
        MinMaxBounds.Ints count;
        ArrayList<MutableComponent> subTexts = new ArrayList<MutableComponent>();
        Optional items = predicate.items();
        if (items.isPresent() && ((HolderSet)items.get()).unwrapKey().isPresent()) {
            subTexts.add(LText.translatable("emi_loot.item_predicate.tag", ((TagKey)((HolderSet)items.get()).unwrapKey().get()).location().toString()));
        }
        if (items.isPresent() && ((HolderSet)items.get()).size() > 0) {
            List<MutableComponent> list = ((HolderSet)items.get()).stream().map(item -> (MutableComponent)((Item)item.value()).getDescription()).toList();
            subTexts.add(LText.translatable("emi_loot.item_predicate.items", ListProcessors.buildOrList(list)));
        }
        if ((count = predicate.count()) != MinMaxBounds.Ints.ANY) {
            int finalMax = count.max().orElse(0);
            int finalMin = count.min().orElse(0);
            subTexts.add(LText.translatable("emi_loot.item_predicate.count", Integer.toString(finalMin), Integer.toString(finalMax)));
        }
        if (!(componentPredicate = predicate.components()).alwaysMatches()) {
            subTexts.add(LText.translatable("emi_loot.predicate.component"));
        }
        Map subPredicates = predicate.subPredicates();
        for (Map.Entry entry : subPredicates.entrySet()) {
            subTexts.add(ItemSubPredicateParser.parseItemSubPredicate((ItemSubPredicate.Type<? extends ItemSubPredicate>)((ItemSubPredicate.Type)entry.getKey()), (ItemSubPredicate)entry.getValue()).plainCopy());
        }
        if (subTexts.isEmpty()) {
            if (EMILoot.DEBUG) {
                EMILoot.LOGGER.warn("Empty item predicate in table: " + LootTableParser.currentTable);
            }
            return LText.translatable("emi_loot.predicate.invalid");
        }
        return ListProcessors.buildAndList(subTexts);
    }
}

