/*
 * Decompiled with CFR 0.152.
 */
package fzzyhmstrs.emi_loot.parser;

import fzzyhmstrs.emi_loot.EMILoot;
import fzzyhmstrs.emi_loot.parser.LootTableParser;
import fzzyhmstrs.emi_loot.parser.processor.ListProcessors;
import fzzyhmstrs.emi_loot.parser.processor.NumberProcessors;
import fzzyhmstrs.emi_loot.util.LText;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.enchantment.Enchantment;

public class EnchantmentPredicateParser {
    public static Component parseEnchantmentPredicates(List<EnchantmentPredicate> list) {
        ArrayList<MutableComponent> list2 = new ArrayList<MutableComponent>();
        for (EnchantmentPredicate predicate : list) {
            Optional enchant = predicate.enchantments();
            if (enchant.isPresent() && ((HolderSet)enchant.get()).unwrapKey().isPresent()) {
                if (predicate.level() == MinMaxBounds.Ints.ANY) {
                    list2.add(LText.translatable("emi_loot.item_predicate.enchant.tag", ((TagKey)((HolderSet)enchant.get()).unwrapKey().get()).location().toString()));
                } else {
                    MutableComponent numberRange = NumberProcessors.processNumberRange(predicate.level(), "emi_loot.item_predicate.enchant.levels_1", "emi_loot.item_predicate.enchant.levels_2", "emi_loot.item_predicate.enchant.levels_3", "emi_loot.item_predicate.enchant.levels_4", "", new Object[0]);
                    MutableComponent e = LText.translatable("emi_loot.item_predicate.enchant.tag", ((TagKey)((HolderSet)enchant.get()).unwrapKey().get()).location().toString());
                    list2.add(LText.translatable("emi_loot.item_predicate.enchant.levels", e, numberRange));
                }
            }
            if (!enchant.isPresent() || ((HolderSet)enchant.get()).size() <= 0) continue;
            List<MutableComponent> list3 = ((HolderSet)enchant.get()).stream().map(entry -> LText.enchant((Holder<Enchantment>)entry).plainCopy()).toList();
            if (predicate.level() == MinMaxBounds.Ints.ANY) {
                list2.add(LText.translatable("emi_loot.item_predicate.enchant.list", ListProcessors.buildOrList(list3)));
                continue;
            }
            MutableComponent numberRange = NumberProcessors.processNumberRange(predicate.level(), "emi_loot.item_predicate.enchant.levels_1", "emi_loot.item_predicate.enchant.levels_2", "emi_loot.item_predicate.enchant.levels_3", "emi_loot.item_predicate.enchant.levels_4", "", new Object[0]);
            MutableComponent e = LText.translatable("emi_loot.item_predicate.enchant.list", ListProcessors.buildOrList(list3));
            list2.add(LText.translatable("emi_loot.item_predicate.enchant.levels", e, numberRange));
        }
        if (!list2.isEmpty()) {
            return LText.translatable("emi_loot.item_predicate.enchant", ListProcessors.buildAndList(list2));
        }
        if (EMILoot.DEBUG) {
            EMILoot.LOGGER.warn("Empty or unparsable enchantment predicate in table: " + LootTableParser.currentTable);
        }
        return LText.translatable("emi_loot.predicate.invalid");
    }
}

