/*
 * Decompiled with CFR 0.152.
 */
package fzzyhmstrs.emi_loot.parser;

import fzzyhmstrs.emi_loot.EMILoot;
import fzzyhmstrs.emi_loot.parser.LootTableParser;
import fzzyhmstrs.emi_loot.parser.processor.ListProcessors;
import fzzyhmstrs.emi_loot.util.LText;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class StatePredicateParser {
    public static Component parseStatePredicate(StatePropertiesPredicate predicate) {
        List list = predicate.properties();
        if (!list.isEmpty()) {
            LinkedList<MutableComponent> list2 = new LinkedList<MutableComponent>();
            for (StatePropertiesPredicate.PropertyMatcher condition : list) {
                Object key;
                StatePropertiesPredicate.ValueMatcher valueMatcher = condition.valueMatcher();
                if (valueMatcher instanceof StatePropertiesPredicate.RangedMatcher) {
                    StatePropertiesPredicate.RangedMatcher rangedValueMatcher = (StatePropertiesPredicate.RangedMatcher)valueMatcher;
                    key = condition.name();
                    String min = rangedValueMatcher.minValue().orElse(null);
                    String max = rangedValueMatcher.maxValue().orElse(null);
                    list2.add(LText.translatable("emi_loot.state_predicate.state_between", key, min, max));
                    continue;
                }
                key = condition.valueMatcher();
                if (!(key instanceof StatePropertiesPredicate.ExactMatcher)) continue;
                StatePropertiesPredicate.ExactMatcher exactValueMatcher = (StatePropertiesPredicate.ExactMatcher)key;
                key = condition.name();
                String value = exactValueMatcher.value();
                list2.add(LText.translatable("emi_loot.state_predicate.state_exact", key, value));
            }
            return LText.translatable("emi_loot.state_predicate.base", ListProcessors.buildAndList(list2));
        }
        if (EMILoot.DEBUG) {
            EMILoot.LOGGER.warn("Empty or unparsable block/fluid state predicate in table: " + LootTableParser.currentTable);
        }
        return LText.translatable("emi_loot.predicate.invalid");
    }
}

