/*
 * Decompiled with CFR 0.152.
 */
package fzzyhmstrs.emi_loot.parser;

import fzzyhmstrs.emi_loot.EMILoot;
import fzzyhmstrs.emi_loot.parser.LootTableParser;
import fzzyhmstrs.emi_loot.util.LText;
import java.util.Optional;
import net.minecraft.advancements.critereon.EntityFlagsPredicate;
import net.minecraft.network.chat.Component;

public class EntityFlagsPredicateParser {
    public static Component parseEntityFlagsPredicate(EntityFlagsPredicate predicate) {
        return LText.translatable("emi_loot.entity_predicate.flag", EntityFlagsPredicateParser.parseEntityFlagsPredicateInternal(predicate));
    }

    private static Component parseEntityFlagsPredicateInternal(EntityFlagsPredicate predicate) {
        Optional isOnFire = predicate.isOnFire();
        if (isOnFire.isPresent()) {
            if (((Boolean)isOnFire.get()).booleanValue()) {
                return LText.translatable("emi_loot.entity_predicate.fire_true");
            }
            return LText.translatable("emi_loot.entity_predicate.fire_false");
        }
        Optional isSneaking = predicate.isCrouching();
        if (isSneaking.isPresent()) {
            if (((Boolean)isSneaking.get()).booleanValue()) {
                return LText.translatable("emi_loot.entity_predicate.sneak_true");
            }
            return LText.translatable("emi_loot.entity_predicate.sneak_false");
        }
        Optional isSprinting = predicate.isSprinting();
        if (isSprinting.isPresent()) {
            if (((Boolean)isSprinting.get()).booleanValue()) {
                return LText.translatable("emi_loot.entity_predicate.sprint_true");
            }
            return LText.translatable("emi_loot.entity_predicate.sprint_false");
        }
        Optional isSwimming = predicate.isSwimming();
        if (isSwimming.isPresent()) {
            if (((Boolean)isSwimming.get()).booleanValue()) {
                return LText.translatable("emi_loot.entity_predicate.swim_true");
            }
            return LText.translatable("emi_loot.entity_predicate.swim_false");
        }
        Optional isBaby = predicate.isBaby();
        if (isBaby.isPresent()) {
            if (((Boolean)isBaby.get()).booleanValue()) {
                return LText.translatable("emi_loot.entity_predicate.baby_true");
            }
            return LText.translatable("emi_loot.entity_predicate.baby_false");
        }
        if (EMILoot.DEBUG) {
            EMILoot.LOGGER.warn("Empty or unparsable entity flags predicate in table: " + LootTableParser.currentTable);
        }
        return LText.translatable("emi_loot.predicate.invalid");
    }
}

