/*
 * Decompiled with CFR 0.152.
 */
package fzzyhmstrs.emi_loot.parser;

import fzzyhmstrs.emi_loot.EMILoot;
import fzzyhmstrs.emi_loot.parser.LootTableParser;
import fzzyhmstrs.emi_loot.parser.processor.ListProcessors;
import fzzyhmstrs.emi_loot.util.LText;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.enchantment.LevelBasedValue;

public class EnchantmentLevelBasedValueParser {
    public static Component parseValue(LevelBasedValue value) {
        return EnchantmentLevelBasedValueParser.parseValue(value, "", 1.0f);
    }

    public static Component parseValue(LevelBasedValue value, String percent, float multiplier) {
        if (value instanceof LevelBasedValue.Constant) {
            LevelBasedValue.Constant constant = (LevelBasedValue.Constant)value;
            return LText.literal(constant.value() * multiplier + percent);
        }
        if (value instanceof LevelBasedValue.Lookup) {
            LevelBasedValue.Lookup lookup = (LevelBasedValue.Lookup)value;
            return LText.translatable("emi_loot.enchantment_value.lookup", ListProcessors.buildOrList(lookup.values().stream().map(f -> LText.literal(f.floatValue() * multiplier + percent)).toList()));
        }
        if (value instanceof LevelBasedValue.Linear) {
            LevelBasedValue.Linear linear = (LevelBasedValue.Linear)value;
            if (linear.base() == linear.perLevelAboveFirst()) {
                return LText.translatable("emi_loot.enchantment_value.linear.simple", linear.base() * multiplier + percent);
            }
            return LText.translatable("emi_loot.enchantment_value.linear", linear.base() * multiplier + percent, linear.perLevelAboveFirst() * multiplier + percent);
        }
        if (value instanceof LevelBasedValue.LevelsSquared) {
            LevelBasedValue.LevelsSquared levelsSquared = (LevelBasedValue.LevelsSquared)value;
            return LText.translatable("emi_loot.enchantment_value.level_squared", levelsSquared.added() * multiplier + percent);
        }
        if (value instanceof LevelBasedValue.Fraction) {
            LevelBasedValue.Fraction fraction = (LevelBasedValue.Fraction)value;
            return LText.translatable("emi_loot.enchantment_value.fraction", EnchantmentLevelBasedValueParser.parseValue(fraction.numerator(), percent, multiplier), EnchantmentLevelBasedValueParser.parseValue(fraction.denominator(), percent, multiplier));
        }
        if (value instanceof LevelBasedValue.Clamped) {
            LevelBasedValue.Clamped clamped = (LevelBasedValue.Clamped)value;
            return LText.translatable("emi_loot.enchantment_value.clamped", EnchantmentLevelBasedValueParser.parseValue(clamped.value(), percent, multiplier), clamped.min() * multiplier + percent, clamped.max() * multiplier + percent);
        }
        if (EMILoot.DEBUG) {
            EMILoot.LOGGER.warn("Unknown or unparsable enchantment-based value in table: " + LootTableParser.currentTable);
        }
        return LText.translatable("emi_loot.enchantment_value.level_squared");
    }
}

