/*
 * Decompiled with CFR 0.152.
 */
package com.pandaismyname1.emiletsdocompat.vinery;

import com.pandaismyname1.emiletsdocompat.MockRecipeIdGenerator;
import dev.architectury.utils.EnvExecutor;
import dev.architectury.utils.GameInstance;
import dev.emi.emi.api.recipe.BasicEmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.SlotWidget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.satisfy.vinery.core.recipe.ApplePressFermentingRecipe;
import net.satisfy.vinery.core.registry.ObjectRegistry;

public class AppleFermentationRecipe
extends BasicEmiRecipe {
    public static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"vinery", (String)"textures/gui/apple_press_gui.png");
    protected static final Supplier<RegistryAccess> REGISTRY_ACCESS = (Supplier)EnvExecutor.getEnvSpecific(() -> () -> () -> GameInstance.getClient().player.level().registryAccess(), () -> () -> () -> GameInstance.getServer().registryAccess());

    public AppleFermentationRecipe(EmiRecipeCategory category, ApplePressFermentingRecipe recipe) {
        super(category, MockRecipeIdGenerator.generateRecipeId(), 70, 18);
        NonNullList ingredients = recipe.getIngredients();
        boolean requiresBottle = recipe.requiresBottle();
        for (Ingredient ingredient : ingredients) {
            this.inputs.add(EmiIngredient.of((Ingredient)ingredient));
        }
        if (requiresBottle) {
            Ingredient ingredient = Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ObjectRegistry.WINE_BOTTLE.get()});
            this.inputs.add(EmiIngredient.of((Ingredient)ingredient));
        }
        this.outputs.add(EmiStack.of((ItemStack)recipe.getResultItem((HolderLookup.Provider)REGISTRY_ACCESS.get())));
    }

    public void addWidgets(WidgetHolder widgets) {
        SlotWidget s;
        widgets.addTexture(TEXTURE, 15, 20, 36, 18, 100, 49);
        widgets.addTexture(TEXTURE, 66, 15, 10, 28, 101, 17);
        widgets.addAnimatedTexture(TEXTURE, 66, 15, 10, 28, 176, 47, 10000, false, true, false);
        widgets.addTexture(TEXTURE, 89, 20, 18, 18, 118, 17);
        if (!this.inputs.isEmpty()) {
            s = widgets.addSlot((EmiIngredient)this.inputs.get(0), 15, 20);
            s.drawBack(false);
        }
        if (this.inputs.size() > 1) {
            s = widgets.addSlot((EmiIngredient)this.inputs.get(1), 33, 20);
            s.drawBack(false);
        }
        if (!this.outputs.isEmpty()) {
            s = widgets.addSlot((EmiIngredient)this.outputs.get(0), 89, 20);
            s.drawBack(false);
        }
    }

    public int getDisplayHeight() {
        return 60;
    }

    public int getDisplayWidth() {
        return 124;
    }
}

