/*
 * Decompiled with CFR 0.152.
 */
package com.pandaismyname1.emiletsdocompat.meadow.internal;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.pandaismyname1.emiletsdocompat.meadow.internal.Registry;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class FondueUseRecipe
implements Recipe<RecipeInput> {
    private final Ingredient ingredient;
    private final ItemStack result;
    private final float cheeseCost;

    public FondueUseRecipe(Ingredient ingredient, ItemStack result, float cheeseCost) {
        this.ingredient = ingredient;
        this.result = result;
        this.cheeseCost = cheeseCost;
    }

    public NonNullList<Ingredient> getIngredients() {
        NonNullList list = NonNullList.create();
        list.add((Object)this.ingredient);
        return list;
    }

    public boolean matches(RecipeInput recipeInput, Level level) {
        return false;
    }

    @NotNull
    public ItemStack assemble(RecipeInput recipeInput, HolderLookup.Provider provider) {
        return this.result.copy();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    @NotNull
    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return this.result.copy();
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public ItemStack getResult() {
        return this.result;
    }

    public float getCheeseCost() {
        return this.cheeseCost;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)Registry.FONDUE_USE_SERIALIZER.get();
    }

    @NotNull
    public RecipeType<?> getType() {
        return (RecipeType)Registry.FONDUE_USE.get();
    }

    public static class Serializer
    implements RecipeSerializer<FondueUseRecipe> {
        @NotNull
        public MapCodec<FondueUseRecipe> codec() {
            return RecordCodecBuilder.mapCodec(inst -> inst.group((App)Ingredient.CODEC.fieldOf("ingredient").forGetter(FondueUseRecipe::getIngredient), (App)ItemStack.CODEC.fieldOf("result").forGetter(FondueUseRecipe::getResult), (App)Codec.FLOAT.fieldOf("cheeseCost").forGetter(FondueUseRecipe::getCheeseCost)).apply((Applicative)inst, FondueUseRecipe::new));
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, FondueUseRecipe> streamCodec() {
            return new StreamCodec<RegistryFriendlyByteBuf, FondueUseRecipe>(this){

                public void encode(RegistryFriendlyByteBuf buf, FondueUseRecipe recipe) {
                    Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buf, (Object)recipe.getIngredient());
                    ItemStack.STREAM_CODEC.encode((Object)buf, (Object)recipe.getResult());
                    buf.writeFloat(recipe.getCheeseCost());
                }

                @NotNull
                public FondueUseRecipe decode(RegistryFriendlyByteBuf buf) {
                    Ingredient ingredient = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buf);
                    ItemStack result = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buf);
                    float cheese = buf.readFloat();
                    return new FondueUseRecipe(ingredient, result, cheese);
                }
            };
        }
    }
}

