/*
 * Decompiled with CFR 0.152.
 */
package com.pandaismyname1.emiletsdocompat.beachparty;

import com.pandaismyname1.emiletsdocompat.MockRecipeIdGenerator;
import dev.architectury.utils.EnvExecutor;
import dev.architectury.utils.GameInstance;
import dev.emi.emi.api.recipe.BasicEmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.SlotWidget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.satisfy.beachparty.client.gui.PalmBarGui;
import net.satisfy.beachparty.core.recipe.PalmBarRecipe;

public class TikiBarMixingRecipe
extends BasicEmiRecipe {
    protected static final Supplier<RegistryAccess> REGISTRY_ACCESS = (Supplier)EnvExecutor.getEnvSpecific(() -> () -> () -> GameInstance.getClient().player.level().registryAccess(), () -> () -> () -> GameInstance.getServer().registryAccess());

    public TikiBarMixingRecipe(EmiRecipeCategory category, PalmBarRecipe recipe) {
        super(category, MockRecipeIdGenerator.generateRecipeId(), 70, 18);
        NonNullList ingredients = recipe.getIngredients();
        for (Ingredient ingredient : ingredients) {
            this.inputs.add(EmiIngredient.of((Ingredient)ingredient));
        }
        this.outputs.add(EmiStack.of((ItemStack)recipe.getResultItem((HolderLookup.Provider)REGISTRY_ACCESS.get())));
    }

    public void addWidgets(WidgetHolder widgets) {
        SlotWidget s;
        widgets.addTexture(PalmBarGui.BG, 0, 0, 106, 42, 34, 21);
        widgets.addAnimatedTexture(PalmBarGui.BG, 45, 13, 24, 17, 176, 14, 5000, true, false, false);
        if (!this.inputs.isEmpty()) {
            s = widgets.addSlot((EmiIngredient)this.inputs.get(0), 3, 3);
            s.drawBack(false);
        }
        if (this.inputs.size() > 1) {
            s = widgets.addSlot((EmiIngredient)this.inputs.get(1), 21, 3);
            s.drawBack(false);
        }
        if (this.inputs.size() > 2) {
            s = widgets.addSlot((EmiIngredient)this.inputs.get(2), 3, 21);
            s.drawBack(false);
        }
        if (this.inputs.size() > 3) {
            s = widgets.addSlot((EmiIngredient)this.inputs.get(3), 21, 21);
            s.drawBack(false);
        }
        if (!this.outputs.isEmpty()) {
            s = widgets.addSlot((EmiIngredient)this.outputs.get(0), 81, 13);
            s.drawBack(false);
        }
    }

    public int getDisplayHeight() {
        return 42;
    }

    public int getDisplayWidth() {
        return 106;
    }
}

