/*
 * Decompiled with CFR 0.152.
 */
package com.pandaismyname1.emiletsdocompat.bakery.internal;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.pandaismyname1.emiletsdocompat.bakery.internal.Registry;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class CakeCutRecipe
implements Recipe<RecipeInput> {
    private static final TagKey<Item> KNIFE_TAG = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"bakery", (String)"knives"));
    private final Ingredient ingredient;
    private final ItemStack result;

    public CakeCutRecipe(Ingredient ingredient, ItemStack result) {
        this.ingredient = ingredient;
        this.result = result;
    }

    @NotNull
    public NonNullList<Ingredient> getIngredients() {
        NonNullList list = NonNullList.create();
        list.add((Object)Ingredient.of(KNIFE_TAG));
        list.add((Object)this.ingredient);
        return list;
    }

    public boolean matches(RecipeInput recipeInput, Level level) {
        return false;
    }

    @NotNull
    public ItemStack assemble(RecipeInput recipeInput, HolderLookup.Provider provider) {
        return this.result.copy();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    @NotNull
    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return this.result.copy();
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)Registry.CAKE_CUT_SERIALIZER.get();
    }

    @NotNull
    public RecipeType<?> getType() {
        return (RecipeType)Registry.CAKE_CUT.get();
    }

    public Ingredient getInput() {
        return this.ingredient;
    }

    public ItemStack getOutput() {
        return this.result;
    }

    public static class Serializer
    implements RecipeSerializer<CakeCutRecipe> {
        @NotNull
        public MapCodec<CakeCutRecipe> codec() {
            return RecordCodecBuilder.mapCodec(inst -> inst.group((App)Ingredient.CODEC.fieldOf("ingredient").forGetter(CakeCutRecipe::getInput), (App)ItemStack.CODEC.fieldOf("result").forGetter(CakeCutRecipe::getOutput)).apply((Applicative)inst, CakeCutRecipe::new));
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, CakeCutRecipe> streamCodec() {
            return new StreamCodec<RegistryFriendlyByteBuf, CakeCutRecipe>(this){

                public void encode(RegistryFriendlyByteBuf buf, CakeCutRecipe recipe) {
                    Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buf, (Object)recipe.getInput());
                    ItemStack.STREAM_CODEC.encode((Object)buf, (Object)recipe.getOutput());
                }

                @NotNull
                public CakeCutRecipe decode(RegistryFriendlyByteBuf buf) {
                    return new CakeCutRecipe((Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buf), (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buf));
                }
            };
        }
    }
}

