/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.recipe;

import dev.emi.emi.EmiPort;
import dev.emi.emi.EmiRenderHelper;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.recipe.VanillaEmiRecipeCategories;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.TextWidget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class EmiCompostingRecipe
implements EmiRecipe {
    private static final EmiStack BONE_MEAL = EmiStack.of((ItemLike)Items.BONE_MEAL);
    private final EmiIngredient stack;
    private final float chance;
    private final ResourceLocation id;

    public EmiCompostingRecipe(EmiIngredient stack, float chance, ResourceLocation id) {
        this.stack = stack;
        this.chance = chance;
        this.id = id;
    }

    @Override
    public EmiRecipeCategory getCategory() {
        return VanillaEmiRecipeCategories.COMPOSTING;
    }

    @Override
    @Nullable
    public ResourceLocation getId() {
        return this.id;
    }

    @Override
    public List<EmiIngredient> getInputs() {
        return List.of(this.stack);
    }

    @Override
    public List<EmiStack> getOutputs() {
        return List.of(BONE_MEAL);
    }

    @Override
    public int getDisplayWidth() {
        return 108;
    }

    @Override
    public int getDisplayHeight() {
        return 18;
    }

    @Override
    public boolean supportsRecipeTree() {
        return false;
    }

    @Override
    public void addWidgets(WidgetHolder widgets) {
        widgets.addSlot(this.stack, 0, 0);
        widgets.addTexture(EmiTexture.EMPTY_ARROW, 46, 1);
        widgets.addText((Component)EmiPort.literal(EmiRenderHelper.TEXT_FORMAT.format(this.chance * 100.0f) + "%"), 32, 5, -1, true).horizontalAlign(TextWidget.Alignment.CENTER);
        widgets.addText((Component)EmiPort.literal("x7"), 74, 5, -1, true);
        widgets.addSlot(BONE_MEAL, 90, 0).recipeContext(this);
    }
}

