/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.handler;

import com.google.common.collect.Lists;
import dev.emi.emi.EmiPort;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.VanillaEmiRecipeCategories;
import dev.emi.emi.api.recipe.handler.EmiCraftContext;
import dev.emi.emi.api.recipe.handler.StandardRecipeHandler;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.StonecutterMenu;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.item.crafting.StonecutterRecipe;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class StonecuttingRecipeHandler
implements StandardRecipeHandler<StonecutterMenu> {
    @Override
    public List<Slot> getInputSources(StonecutterMenu handler) {
        int invStart;
        ArrayList list = Lists.newArrayList();
        list.add(handler.getSlot(0));
        for (int i = invStart = 2; i < invStart + 36; ++i) {
            list.add(handler.getSlot(i));
        }
        return list;
    }

    @Override
    public List<Slot> getCraftingSlots(StonecutterMenu handler) {
        return List.of((Slot)handler.slots.get(0));
    }

    @Override
    public boolean supportsRecipe(EmiRecipe recipe) {
        return recipe.getCategory() == VanillaEmiRecipeCategories.STONECUTTING;
    }

    @Override
    @Nullable
    public Slot getOutputSlot(StonecutterMenu handler) {
        return handler.getSlot(1);
    }

    @Override
    public boolean craft(EmiRecipe recipe, EmiCraftContext<StonecutterMenu> context) {
        boolean action = StandardRecipeHandler.super.craft(recipe, context);
        Minecraft client = Minecraft.getInstance();
        ClientLevel world = client.level;
        SingleRecipeInput inv = new SingleRecipeInput(recipe.getInputs().get(0).getEmiStacks().get(0).getItemStack());
        List<StonecutterRecipe> recipes = world.getRecipeManager().getRecipesFor(RecipeType.STONECUTTING, (RecipeInput)inv, (Level)world).stream().map(RecipeHolder::value).toList();
        for (int i = 0; i < recipes.size(); ++i) {
            if (EmiPort.getId((Recipe)recipes.get(i)) == null || !EmiPort.getId((Recipe)recipes.get(i)).equals((Object)recipe.getId())) continue;
            StonecutterMenu sh = context.getScreenHandler();
            client.gameMode.handleInventoryButtonClick(sh.containerId, i);
            if (context.getDestination() == EmiCraftContext.Destination.CURSOR) {
                client.gameMode.handleInventoryMouseClick(sh.containerId, 1, 0, ClickType.PICKUP, (Player)client.player);
                break;
            }
            if (context.getDestination() != EmiCraftContext.Destination.INVENTORY) break;
            client.gameMode.handleInventoryMouseClick(sh.containerId, 1, 0, ClickType.QUICK_MOVE, (Player)client.player);
            break;
        }
        return action;
    }
}

