/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.api.stack;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.Lighting;
import dev.emi.emi.EmiPort;
import dev.emi.emi.EmiRenderHelper;
import dev.emi.emi.api.render.EmiRender;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.platform.EmiAgnos;
import dev.emi.emi.runtime.EmiDrawContext;
import dev.emi.emi.screen.StackBatcher;
import dev.emi.emi.screen.tooltip.EmiTextTooltipWrapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTextTooltip;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class ItemEmiStack
extends EmiStack
implements StackBatcher.Batchable {
    private static final Minecraft client = Minecraft.getInstance();
    private final Item item;
    private final DataComponentPatch componentChanges;
    private boolean unbatchable;

    public ItemEmiStack(ItemStack stack) {
        this(stack, stack.getCount());
    }

    public ItemEmiStack(ItemStack stack, long amount) {
        this(stack.getItem(), stack.getComponentsPatch(), amount);
    }

    public ItemEmiStack(Item item, DataComponentPatch components, long amount) {
        this.item = item;
        this.componentChanges = components;
        this.amount = amount;
    }

    @Override
    public ItemStack getItemStack() {
        return new ItemStack(EmiPort.getItemRegistry().wrapAsHolder((Object)this.item), (int)this.amount, this.componentChanges);
    }

    @Override
    public EmiStack copy() {
        ItemEmiStack e = new ItemEmiStack(this.item, this.componentChanges, this.amount);
        e.setChance(this.chance);
        e.setRemainder(this.getRemainder().copy());
        e.comparison = this.comparison;
        return e;
    }

    @Override
    public boolean isEmpty() {
        return this.amount == 0L || this.item == Items.AIR;
    }

    @Override
    public DataComponentPatch getComponentChanges() {
        return this.componentChanges;
    }

    @Override
    @Nullable
    public <T> T get(DataComponentType<? extends T> type) {
        Optional changedOpt = this.componentChanges.get(type);
        if (changedOpt != null) {
            return changedOpt.orElse(null);
        }
        return (T)this.item.components().get(type);
    }

    @Override
    public Object getKey() {
        return this.item;
    }

    @Override
    public ResourceLocation getId() {
        return EmiPort.getItemRegistry().getKey((Object)this.item);
    }

    @Override
    public void render(GuiGraphics draw, int x, int y, float delta, int flags) {
        EmiDrawContext context = EmiDrawContext.wrap(draw);
        ItemStack stack = this.getItemStack();
        if ((flags & 1) != 0) {
            Lighting.setupFor3DItems();
            draw.renderFakeItem(stack, x, y);
            draw.renderItemDecorations(ItemEmiStack.client.font, stack, x, y, "");
        }
        if ((flags & 2) != 0) {
            Object count = "";
            if (this.amount != 1L) {
                count = (String)count + this.amount;
            }
            EmiRenderHelper.renderAmount(context, x, y, (Component)EmiPort.literal((String)count));
        }
        if ((flags & 8) != 0) {
            EmiRender.renderRemainderIcon(this, context.raw(), x, y);
        }
    }

    @Override
    public boolean isSideLit() {
        return client.getItemRenderer().getModel(this.getItemStack(), null, null, 0).usesBlockLight();
    }

    @Override
    public boolean isUnbatchable() {
        ItemStack stack = this.getItemStack();
        return this.unbatchable || stack.hasFoil() || stack.isDamaged() || !EmiAgnos.canBatch(stack) || client.getItemRenderer().getModel(this.getItemStack(), null, null, 0).isCustomRenderer();
    }

    @Override
    public void setUnbatchable() {
        this.unbatchable = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renderForBatch(MultiBufferSource vcp, GuiGraphics draw, int x, int y, int z, float delta) {
        EmiDrawContext context = EmiDrawContext.wrap(draw);
        ItemStack stack = this.getItemStack();
        ItemRenderer ir = client.getItemRenderer();
        BakedModel model = ir.getModel(stack, null, null, 0);
        context.push();
        try {
            context.matrices().translate((float)x, (float)y, 100.0f + (float)z + (float)(model.isGui3d() ? 50 : 0));
            context.matrices().translate(8.0, 8.0, 0.0);
            context.matrices().scale(16.0f, -16.0f, 16.0f);
            ir.render(stack, ItemDisplayContext.GUI, false, context.matrices(), vcp, 0xF000F0, OverlayTexture.NO_OVERLAY, model);
        }
        finally {
            context.pop();
        }
    }

    @Override
    public List<Component> getTooltipText() {
        if (client.isSameThread()) {
            return this.getItemStack().getTooltipLines(Item.TooltipContext.of((Level)ItemEmiStack.client.level), (Player)ItemEmiStack.client.player, (TooltipFlag)TooltipFlag.NORMAL);
        }
        return this.getItemStack().getTooltipLines(Item.TooltipContext.of((HolderLookup.Provider)ItemEmiStack.client.level.registryAccess()), null, (TooltipFlag)TooltipFlag.NORMAL);
    }

    @Override
    public List<ClientTooltipComponent> getTooltip() {
        ItemStack stack = this.getItemStack();
        ArrayList list = Lists.newArrayList();
        if (!this.isEmpty()) {
            Object e;
            list.addAll(EmiAgnos.getItemTooltip(stack));
            if (!list.isEmpty() && (e = list.get(0)) instanceof ClientTextTooltip) {
                ClientTextTooltip ottc = (ClientTextTooltip)e;
                list.set(0, new EmiTextTooltipWrapper((EmiIngredient)this, ottc));
            }
            list.addAll(super.getTooltip());
        }
        return list;
    }

    @Override
    public Component getName() {
        if (this.isEmpty()) {
            return EmiPort.literal("");
        }
        return this.getItemStack().getHoverName();
    }

    static class ItemEntry {
        ItemEntry() {
        }
    }
}

