/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.render.chunk.lists;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.embeddedt.embeddium.impl.render.chunk.RenderSection;
import org.embeddedt.embeddium.impl.render.chunk.lists.ChunkRenderList;
import org.embeddedt.embeddium.impl.render.chunk.lists.ChunkRenderListIterable;
import org.embeddedt.embeddium.impl.render.chunk.region.RenderRegion;
import org.embeddedt.embeddium.impl.util.iterator.ReversibleObjectArrayIterator;

public class SortedRenderLists
implements ChunkRenderListIterable {
    private static final SortedRenderLists EMPTY = new SortedRenderLists((ObjectArrayList<ChunkRenderList>)ObjectArrayList.of());
    private final ObjectArrayList<ChunkRenderList> lists;

    SortedRenderLists(ObjectArrayList<ChunkRenderList> lists) {
        this.lists = lists;
    }

    public ReversibleObjectArrayIterator<ChunkRenderList> iterator(boolean reverse) {
        return new ReversibleObjectArrayIterator<ChunkRenderList>(this.lists, reverse);
    }

    public static SortedRenderLists empty() {
        return EMPTY;
    }

    public static class Builder {
        private final ObjectArrayList<ChunkRenderList> lists = new ObjectArrayList();
        private final int frame;

        public Builder(int frame) {
            this.frame = frame;
        }

        public void add(RenderSection section) {
            RenderRegion region = section.getRegion();
            ChunkRenderList list = region.getRenderList();
            if (list.getLastVisibleFrame() != this.frame) {
                list.reset(this.frame);
                this.lists.add((Object)list);
            }
            if (section.getFlags() != 0) {
                list.add(section);
            }
        }

        public SortedRenderLists build() {
            ObjectArrayList filtered = new ObjectArrayList(this.lists.size());
            for (ChunkRenderList list : this.lists) {
                if (list.size() <= 0) continue;
                filtered.add((Object)list);
            }
            return new SortedRenderLists((ObjectArrayList<ChunkRenderList>)filtered);
        }
    }
}

