/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.model.light.data;

import it.unimi.dsi.fastutil.longs.Long2IntLinkedOpenHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;
import org.embeddedt.embeddium.impl.model.light.data.LightDataAccess;

public class HashLightDataCache
extends LightDataAccess {
    private final Long2IntLinkedOpenHashMap map = new Long2IntLinkedOpenHashMap(1024, 0.5f);

    public HashLightDataCache(BlockAndTintGetter world) {
        this.world = world;
    }

    @Override
    public int get(int x, int y, int z) {
        long key = BlockPos.asLong((int)x, (int)y, (int)z);
        int word = this.map.getAndMoveToFirst(key);
        if (word == 0) {
            if (this.map.size() > 1024) {
                this.map.removeLastInt();
            }
            word = this.compute(x, y, z);
            this.map.put(key, word);
        }
        return word;
    }

    public void clearCache() {
        this.map.clear();
    }
}

