/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.gametest.network;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.Minecraft;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.embeddedt.embeddium.impl.gametest.content.TestRegistry;

public class SyncS2CPacket
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<SyncS2CPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"embeddium", (String)"test_barrier"));
    public static final StreamCodec<ByteBuf, SyncS2CPacket> STREAM_CODEC = UUIDUtil.STREAM_CODEC.map(SyncS2CPacket::new, p -> p.uuid);
    private final UUID uuid;
    private static final ConcurrentHashMap<UUID, CountDownLatch> LATCHES = new ConcurrentHashMap();

    public SyncS2CPacket() {
        this.uuid = UUID.randomUUID();
    }

    public SyncS2CPacket(UUID uuid) {
        this.uuid = uuid;
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void applyBarrier() {
        CountDownLatch latch = new CountDownLatch(1);
        CountDownLatch prevLatch = LATCHES.put(this.uuid, latch);
        if (prevLatch != null) {
            throw new IllegalStateException("Existing latch found for barrier UUID: " + String.valueOf(this.uuid));
        }
        TestRegistry.LOGGER.debug("Waiting at barrier {}", (Object)this.uuid);
        ServerPlayer player = (ServerPlayer)Minecraft.getInstance().getSingleplayerServer().getPlayerList().getPlayers().getFirst();
        player.connection.resumeFlushing();
        PacketDistributor.sendToAllPlayers((CustomPacketPayload)this, (CustomPacketPayload[])new CustomPacketPayload[0]);
        player.connection.suspendFlushing();
        try {
            if (!latch.await(10L, TimeUnit.SECONDS)) {
                throw new IllegalStateException("Client did not reach barrier " + String.valueOf(this.uuid));
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        TestRegistry.LOGGER.debug("Continuing past barrier {}", (Object)this.uuid);
    }

    public void handle(IPayloadContext context) {
        context.enqueueWork(() -> {
            CountDownLatch latch = LATCHES.remove(this.uuid);
            if (latch == null) {
                throw new IllegalStateException("Latch for " + String.valueOf(this.uuid) + " not found");
            }
            TestRegistry.LOGGER.debug("Reached barrier {}", (Object)this.uuid);
            latch.countDown();
        });
    }
}

