/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.elytraslot.common.integration.deeperdarker;

import com.illusivesoulworks.elytraslot.platform.Services;
import com.kyanite.deeperdarker.DeeperDarkerConfig;
import com.kyanite.deeperdarker.content.DDItems;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record SoulElytraBoostPayload(boolean bool) implements CustomPacketPayload
{
    public static final StreamCodec<ByteBuf, SoulElytraBoostPayload> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, SoulElytraBoostPayload::bool, SoulElytraBoostPayload::new);
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"elytraslot", (String)"soul_elytra_boost");
    public static final CustomPacketPayload.Type<SoulElytraBoostPayload> TYPE = new CustomPacketPayload.Type(ID);

    @Nonnull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void handle(IPayloadContext context) {
        context.enqueueWork(() -> {
            Player player = context.player();
            Level level = player.level();
            if (DeeperDarkerConfig.soulElytraCooldown == -1) {
                player.displayClientMessage((Component)Component.translatable((String)"item.deeperdarker.soul_elytra.no_cooldown"), true);
                return;
            }
            if (player.isFallFlying() && Services.ELYTRA.getEquipped((LivingEntity)player).is((Holder)DDItems.SOUL_ELYTRA) && !player.getCooldowns().isOnCooldown((Item)DDItems.SOUL_ELYTRA.get())) {
                FireworkRocketEntity rocket = new FireworkRocketEntity(level, new ItemStack((ItemLike)Items.FIREWORK_ROCKET), (LivingEntity)player);
                level.addFreshEntity((Entity)rocket);
                player.getCooldowns().addCooldown((Item)DDItems.SOUL_ELYTRA.get(), DeeperDarkerConfig.soulElytraCooldown);
            }
        });
    }
}

