/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.duckling.neoforge;

import java.util.HashMap;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.SpawnPlacementType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import tech.thatgravyboat.duckling.Duckling;
import tech.thatgravyboat.duckling.common.registry.ModSpawns;
import tech.thatgravyboat.duckling.neoforge.DucklingNeoForgeClient;

@Mod(value="duckling")
public class DucklingNeoForge {
    public DucklingNeoForge(IEventBus bus) {
        Duckling.init();
        bus.addListener(DucklingNeoForge::addEntityAttributes);
        bus.addListener(this::setup);
        bus.addListener(DucklingNeoForge::onModifyCreativeTabs);
        bus.addListener(this::onSpawnPlacement);
        if (FMLLoader.getDist().isClient()) {
            DucklingNeoForgeClient.init(bus);
        }
    }

    public void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(Duckling::lateInit);
    }

    public void onSpawnPlacement(final RegisterSpawnPlacementsEvent event) {
        ModSpawns.addSpawnRules(new ModSpawns.SpawnRegistrar(){

            @Override
            public <T extends Mob> void register(EntityType<T> entityType, SpawnPlacementType spawnPlacementType, Heightmap.Types types, SpawnPlacements.SpawnPredicate<T> spawnPredicate) {
                event.register(entityType, spawnPlacementType, types, spawnPredicate, RegisterSpawnPlacementsEvent.Operation.OR);
            }
        });
    }

    public static void onModifyCreativeTabs(BuildCreativeModeTabContentsEvent event) {
        Duckling.addCreativeTabContent((ResourceKey<CreativeModeTab>)event.getTabKey(), arg_0 -> ((BuildCreativeModeTabContentsEvent)event).accept(arg_0));
    }

    public static void addEntityAttributes(EntityAttributeCreationEvent event) {
        HashMap<EntityType<? extends LivingEntity>, AttributeSupplier.Builder> attributes = new HashMap<EntityType<? extends LivingEntity>, AttributeSupplier.Builder>();
        Duckling.addEntityAttributes(attributes);
        attributes.forEach((entity, builder) -> event.put(entity, builder.build()));
    }
}

