/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.duckling.common.registry;

import com.teamresourceful.resourcefullib.common.registry.ResourcefulRegistries;
import com.teamresourceful.resourcefullib.common.registry.ResourcefulRegistry;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SpawnEggItem;
import tech.thatgravyboat.duckling.common.items.DuckEggItem;
import tech.thatgravyboat.duckling.common.items.HolidayFruitCakeItem;
import tech.thatgravyboat.duckling.common.registry.ModBlocks;
import tech.thatgravyboat.duckling.common.registry.ModEntities;
import tech.thatgravyboat.duckling.common.registry.neoforge.ModItemsImpl;

public class ModItems {
    public static final ResourcefulRegistry<Item> ITEMS = ResourcefulRegistries.create((Registry)BuiltInRegistries.ITEM, (String)"duckling");
    private static final FoodProperties FRUIT_CAKE_FOOD = new FoodProperties.Builder().nutrition(3).saturationModifier(1.0f).build();
    private static final FoodProperties RAW_DUCK_FOOD = new FoodProperties.Builder().nutrition(2).saturationModifier(0.3f).effect(new MobEffectInstance(MobEffects.HUNGER, 600, 0), 0.3f).build();
    private static final FoodProperties COOKED_DUCK_FOOD = new FoodProperties.Builder().nutrition(6).saturationModifier(0.6f).build();
    public static final Supplier<Item> HOLIDAY_FRUIT_CAKE = ITEMS.register("holiday_fruit_cake", () -> new HolidayFruitCakeItem(ModBlocks.HOLIDAY_FRUIT_CAKE_BLOCK.get(), new Item.Properties().food(FRUIT_CAKE_FOOD)));
    public static final Supplier<Item> RAW_DUCK = ITEMS.register("raw_duck", () -> new Item(new Item.Properties().food(RAW_DUCK_FOOD)));
    public static final Supplier<Item> COOKED_DUCK = ITEMS.register("cooked_duck", () -> new Item(new Item.Properties().food(COOKED_DUCK_FOOD)));
    public static final Supplier<SpawnEggItem> QUACKLING_SPAWN_EGG = ITEMS.register("quackling_spawn_egg", ModItems.registerSpawnEgg(ModEntities.QUACKLING, 16435526, 8693820, new Item.Properties()));
    public static final Supplier<SpawnEggItem> DUCK_SPAWN_EGG = ITEMS.register("duck_spawn_egg", ModItems.registerSpawnEgg(ModEntities.DUCK, 5452574, 3184167, new Item.Properties()));
    public static final Supplier<Item> DUCK_EGG = ITEMS.register("duck_egg", () -> new DuckEggItem(new Item.Properties()));

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <T extends Mob> Supplier<SpawnEggItem> registerSpawnEgg(Supplier<EntityType<T>> entity, int primaryColor, int secondaryColor, Item.Properties settings) {
        void var3_3;
        void var2_2;
        void var1_1;
        return ModItemsImpl.registerSpawnEgg(entity, (int)var1_1, (int)var2_2, (Item.Properties)var3_3);
    }
}

