/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.duckling.common.entity;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.EnumSet;
import java.util.function.Predicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.stats.Stats;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.InteractGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.LookAtTradingPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.TradeWithPlayerGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;
import tech.thatgravyboat.duckling.common.constants.AnimationConstants;
import tech.thatgravyboat.duckling.common.items.ModTags;
import tech.thatgravyboat.duckling.common.registry.ModEntities;
import tech.thatgravyboat.duckling.common.registry.ModItems;
import tech.thatgravyboat.duckling.common.registry.ModSounds;

public class QuacklingEntity
extends AbstractVillager
implements GeoEntity {
    private static final VillagerTrades.ItemListing HOLIDAY_CAKE = (entity, random) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 3), new ItemStack((ItemLike)ModItems.HOLIDAY_FRUIT_CAKE.get(), 3), 12, 10, 0.05f);
    public static final Ingredient BREEDING_INGREDIENT = Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.HOLIDAY_FRUIT_CAKE.get()});
    private static final EntityDataAccessor<Boolean> DRIPPED = SynchedEntityData.defineId(QuacklingEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<ItemStack> FISHING_ROD = SynchedEntityData.defineId(QuacklingEntity.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public QuacklingEntity(EntityType<? extends AbstractVillager> entityType, Level world) {
        super(entityType, world);
    }

    public static AttributeSupplier.Builder createQuacklingAttributes() {
        return Mob.createMobAttributes().add(Attributes.MOVEMENT_SPEED, 0.25);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DRIPPED, (Object)false);
        builder.define(FISHING_ROD, (Object)ItemStack.EMPTY);
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficultyInstance, MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnGroupData) {
        SpawnGroupData group = super.finalizeSpawn(level, difficultyInstance, mobSpawnType, spawnGroupData);
        this.setDripped(level.getRandom().nextBoolean());
        return group;
    }

    public boolean isDripped() {
        return (Boolean)this.getEntityData().get(DRIPPED);
    }

    public void setDripped(boolean dripped) {
        this.getEntityData().set(DRIPPED, (Object)dripped);
    }

    public boolean isFishing() {
        return !((ItemStack)this.getEntityData().get(FISHING_ROD)).isEmpty();
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new TradeWithPlayerGoal((AbstractVillager)this));
        this.goalSelector.addGoal(1, (Goal)new PanicGoal((PathfinderMob)this, 1.2));
        this.goalSelector.addGoal(1, (Goal)new LookAtTradingPlayerGoal((AbstractVillager)this));
        this.goalSelector.addGoal(2, (Goal)new FishingGoal(this));
        this.goalSelector.addGoal(3, (Goal)new TemptGoal((PathfinderMob)this, 1.0, (Predicate)BREEDING_INGREDIENT, false));
        this.goalSelector.addGoal(4, (Goal)new MoveTowardsRestrictionGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(9, (Goal)new InteractGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.goalSelector.addGoal(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return ModSounds.DEEP_QUACK.get();
    }

    @Nullable
    protected SoundEvent getHurtSound(@NotNull DamageSource source) {
        return ModSounds.QUACKLING_DEATH.get();
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return ModSounds.QUACKLING_DEATH.get();
    }

    @NotNull
    public SoundEvent getNotifyTradeSound() {
        return ModSounds.DEEP_QUACK.get();
    }

    @NotNull
    protected SoundEvent getTradeUpdatedSound(boolean sold) {
        return ModSounds.DEEP_QUACK.get();
    }

    public void playCelebrateSound() {
    }

    public boolean hurt(@NotNull DamageSource source, float amount) {
        if (!this.isInvulnerableTo(source)) {
            if (this.isFishing()) {
                ItemStack stack = ((ItemStack)this.getEntityData().get(FISHING_ROD)).copy();
                this.spawnAtLocation(stack);
                this.getEntityData().set(FISHING_ROD, (Object)ItemStack.EMPTY);
            }
            this.level().broadcastEntityEvent((Entity)this, (byte)13);
        }
        return super.hurt(source, amount);
    }

    protected void rewardTradeXp(@NotNull MerchantOffer merchantOffer) {
        this.level().broadcastEntityEvent((Entity)this, (byte)14);
    }

    public void handleEntityEvent(byte status) {
        if (status == 13) {
            this.addParticlesAroundSelf((ParticleOptions)ParticleTypes.ANGRY_VILLAGER);
        } else if (status == 14) {
            this.addParticlesAroundSelf((ParticleOptions)ParticleTypes.HAPPY_VILLAGER);
        } else {
            super.handleEntityEvent(status);
        }
    }

    protected void updateTrades() {
        this.fillRecipesForLevel(1);
        this.fillRecipesForLevel(2);
        this.fillRecipesForLevel(3);
        this.getOffers().add((Object)HOLIDAY_CAKE.getOffer((Entity)this, this.random));
    }

    private void fillRecipesForLevel(int level) {
        VillagerTrades.ItemListing[] factories;
        Int2ObjectMap int2ObjectMap = (Int2ObjectMap)VillagerTrades.TRADES.get(VillagerProfession.FISHERMAN);
        if (int2ObjectMap != null && !int2ObjectMap.isEmpty() && (factories = (VillagerTrades.ItemListing[])int2ObjectMap.get(level)) != null) {
            MerchantOffers tradeOfferList = this.getOffers();
            this.addOffersFromItemListings(tradeOfferList, factories, 2);
        }
    }

    public boolean showProgressBar() {
        return false;
    }

    @NotNull
    public InteractionResult mobInteract(Player player, @NotNull InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        if (itemStack.is(ModTags.FISHING_RODS) && !this.isFishing()) {
            this.getEntityData().set(FISHING_ROD, (Object)itemStack);
            player.setItemInHand(hand, ItemStack.EMPTY);
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        }
        if (this.isFishing() && itemStack.isEmpty() && player.isShiftKeyDown()) {
            ItemStack stack = ((ItemStack)this.getEntityData().get(FISHING_ROD)).copy();
            this.getEntityData().set(FISHING_ROD, (Object)ItemStack.EMPTY);
            player.setItemInHand(hand, stack);
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        }
        if (itemStack.is(ModTags.SHEARS) && this.isDripped()) {
            this.setDripped(false);
            this.spawnAtLocation((ItemLike)Items.BIG_DRIPLEAF);
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        }
        if (this.getHealth() < this.getMaxHealth() && itemStack.is(ModItems.HOLIDAY_FRUIT_CAKE.get()) && this.isAlive()) {
            this.heal(1.0f);
            itemStack.shrink(1);
            this.level().addParticle((ParticleOptions)ParticleTypes.HEART, this.getRandomX(1.0), this.getRandomY() + 0.5, this.getRandomX(1.0), this.random.nextGaussian() * 0.02, this.random.nextGaussian() * 0.02, this.random.nextGaussian() * 0.02);
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        }
        if (!itemStack.is((Item)ModItems.QUACKLING_SPAWN_EGG.get()) && this.isAlive() && !this.isTrading() && !this.isFishing()) {
            if (hand == InteractionHand.MAIN_HAND) {
                player.awardStat(Stats.TALKED_TO_VILLAGER);
            }
            if (!this.level().isClientSide() && !this.getOffers().isEmpty()) {
                this.setTradingPlayer(player);
                this.openTradingScreen(player, this.getDisplayName(), 1);
            }
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        }
        return super.mobInteract(player, hand);
    }

    public void readAdditionalSaveData(@NotNull CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        this.setDripped(nbt.getBoolean("Dripped"));
        if (nbt.contains("FishingRod", 10)) {
            this.getEntityData().set(FISHING_ROD, (Object)ItemStack.parseOptional((HolderLookup.Provider)this.level().registryAccess(), (CompoundTag)nbt.getCompound("FishingRod")));
        }
    }

    public void addAdditionalSaveData(@NotNull CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        nbt.putBoolean("Dripped", this.isDripped());
        ItemStack stack = (ItemStack)this.getEntityData().get(FISHING_ROD);
        if (!stack.isEmpty()) {
            nbt.put("FishingRod", stack.save((HolderLookup.Provider)this.level().registryAccess()));
        }
    }

    @Nullable
    public QuacklingEntity getBreedOffspring(@NotNull ServerLevel world, @NotNull AgeableMob entity) {
        return (QuacklingEntity)((EntityType)ModEntities.QUACKLING.get()).create((Level)world);
    }

    public boolean requiresCustomPersistence() {
        return true;
    }

    private <E extends GeoAnimatable> PlayState predicate(AnimationState<E> event) {
        if (this.isFishing()) {
            event.getController().setAnimation(AnimationConstants.FISHING);
        } else if (event.isMoving()) {
            event.getController().setAnimation(AnimationConstants.WALKING);
        } else {
            event.getController().setAnimation(AnimationConstants.IDLE);
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController((GeoAnimatable)this, "controller", 10, this::predicate));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    static class FishingGoal
    extends Goal {
        private final QuacklingEntity entity;

        public FishingGoal(QuacklingEntity entity) {
            this.entity = entity;
            this.setFlags(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean canUse() {
            return this.entity.isFishing();
        }
    }
}

