/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentumbluemap.datagen;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.ldtteam.domumornamentum.block.ModBlocks;
import com.ldtteam.domumornamentumbluemap.registry.MateriallyTexturedBlockRendererType;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;

public class DomumBlockStateProvider
implements DataProvider {
    private final PackOutput packOutput;
    private final ResourceManager resourceManager;

    public DomumBlockStateProvider(PackOutput packOutput, ResourceManager resourceManager) {
        this.packOutput = packOutput;
        this.resourceManager = resourceManager;
    }

    @NotNull
    public CompletableFuture<?> run(@NotNull CachedOutput output) {
        List<ResourceLocation> materialBlocks = Arrays.stream(ModBlocks.getMateriallyTexturableBlocks()).map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.BLOCK).getKey(arg_0)).map(m -> m.withPrefix("blockstates/").withSuffix(".json")).toList();
        List allBlockStates = this.resourceManager.listResources("blockstates", materialBlocks::contains).entrySet().stream().toList();
        CompletableFuture[] futures = new CompletableFuture[allBlockStates.size()];
        for (int i = 0; i < allBlockStates.size(); ++i) {
            futures[i] = this.saveBlockState((ResourceLocation)((Map.Entry)allBlockStates.get(i)).getKey(), (Resource)((Map.Entry)allBlockStates.get(i)).getValue(), output);
        }
        return CompletableFuture.allOf(futures).thenRun(this::blueMapPackCopy);
    }

    @NotNull
    public String getName() {
        return "Domum Block States Provider";
    }

    private CompletableFuture<?> saveBlockState(ResourceLocation key, Resource value, CachedOutput output) {
        try {
            Path outputPath = this.packOutput.getOutputFolder(PackOutput.Target.RESOURCE_PACK).resolve(key.getNamespace()).resolve(key.getPath());
            JsonElement jsonElement = JsonParser.parseReader((Reader)value.openAsReader());
            if (!jsonElement.isJsonObject()) {
                return DataProvider.saveStable((CachedOutput)output, (JsonElement)jsonElement, (Path)outputPath);
            }
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            for (Map.Entry entry : GsonHelper.getAsJsonObject((JsonObject)jsonObject, (String)"variants", (JsonObject)new JsonObject()).entrySet()) {
                if (!((JsonElement)entry.getValue()).isJsonObject()) continue;
                JsonObject variant = ((JsonElement)entry.getValue()).getAsJsonObject();
                variant.addProperty("renderer", MateriallyTexturedBlockRendererType.RENDERER_TYPE_KEY.getFormatted());
            }
            for (Map.Entry entry : GsonHelper.getAsJsonArray((JsonObject)jsonObject, (String)"multipart", (JsonArray)new JsonArray())) {
                JsonObject multipart;
                if (!entry.isJsonObject() || !(multipart = entry.getAsJsonObject()).has("apply") || !multipart.get("apply").isJsonObject()) continue;
                JsonObject apply = multipart.getAsJsonObject("apply");
                apply.addProperty("renderer", MateriallyTexturedBlockRendererType.RENDERER_TYPE_KEY.getFormatted());
            }
            return DataProvider.saveStable((CachedOutput)output, (JsonElement)jsonObject, (Path)outputPath);
        }
        catch (Exception e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    private void blueMapPackCopy() {
        try {
            Path sourceDirectory = Paths.get(String.format("../../src/datagen/generated/%s/assets", "domumornamentumbluemap"), new String[0]);
            Path targetDirectory = Paths.get("./../client/config/bluemap/packs/local/assets", new String[0]);
            Files.createDirectories(targetDirectory, new FileAttribute[0]);
            Files.writeString(targetDirectory.getParent().resolve("pack.mcmeta"), (CharSequence)"{\"pack\":{\"description\":{\"text\":\"Local copy of assets\"},\"pack_format\":48}}", StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            FileUtils.copyDirectory((File)sourceDirectory.toFile(), (File)targetDirectory.toFile());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

