/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.datagen.global;

import com.ldtteam.domumornamentum.block.ModBlocks;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class GlobalRecipeProvider
extends RecipeProvider {
    public GlobalRecipeProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        super(packOutput, lookupProvider);
    }

    private static void buildCutterRecipe(RecipeOutput writer) {
        ShapedRecipeBuilder cutterRecipeBuilder = new ShapedRecipeBuilder(RecipeCategory.TOOLS, (ItemLike)ModBlocks.getInstance().getArchitectsCutter().asItem(), 1);
        cutterRecipeBuilder.define(Character.valueOf('X'), (ItemLike)Items.IRON_INGOT);
        cutterRecipeBuilder.define(Character.valueOf('S'), (ItemLike)Items.STONE_SLAB);
        cutterRecipeBuilder.define(Character.valueOf('L'), ItemTags.LOGS);
        cutterRecipeBuilder.pattern(" X ");
        cutterRecipeBuilder.pattern("SSS");
        cutterRecipeBuilder.pattern("LLL");
        cutterRecipeBuilder.unlockedBy("has_iron_ingot", GlobalRecipeProvider.has((ItemLike)Items.IRON_INGOT));
        cutterRecipeBuilder.unlockedBy("has_stone_slab", GlobalRecipeProvider.has((ItemLike)Items.STONE_SLAB));
        cutterRecipeBuilder.unlockedBy("has_log", GlobalRecipeProvider.has((TagKey)ItemTags.LOGS));
        cutterRecipeBuilder.save(writer);
    }

    protected void buildRecipes(@NotNull RecipeOutput recipeOutput) {
        GlobalRecipeProvider.buildCutterRecipe(recipeOutput);
        this.buildBarrelRecipe(recipeOutput);
    }

    private void buildBarrelRecipe(RecipeOutput writer) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)ModBlocks.getInstance().getStandingBarrel()).define(Character.valueOf('S'), (ItemLike)Items.STICK).define(Character.valueOf('W'), ItemTags.PLANKS).pattern("SWS").pattern("SWS").pattern("SWS").unlockedBy("has_stick", GlobalRecipeProvider.has((ItemLike)Items.STICK)).unlockedBy("has_planks", GlobalRecipeProvider.has((TagKey)ItemTags.PLANKS)).save(writer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)ModBlocks.getInstance().getLayingBarrel()).define(Character.valueOf('S'), (ItemLike)Items.STICK).define(Character.valueOf('W'), ItemTags.PLANKS).pattern("SSS").pattern("WWW").pattern("SSS").unlockedBy("has_stick", GlobalRecipeProvider.has((ItemLike)Items.STICK)).unlockedBy("has_planks", GlobalRecipeProvider.has((TagKey)ItemTags.PLANKS)).save(writer);
    }

    @NotNull
    public String getName() {
        return "Global Blocks Recipe Provider";
    }
}

