/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.datagen.frames.light;

import com.ldtteam.domumornamentum.block.ModBlocks;
import com.ldtteam.domumornamentum.block.decorative.FramedLightBlock;
import com.ldtteam.domumornamentum.datagen.MateriallyTexturedModelBuilder;
import com.ldtteam.domumornamentum.datagen.utils.ModelBuilderUtils;
import java.util.Objects;
import net.minecraft.data.DataGenerator;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.NotNull;

public class FramedLightBlockStateProvider
extends BlockStateProvider {
    public FramedLightBlockStateProvider(DataGenerator gen, ExistingFileHelper exFileHelper) {
        super(gen.getPackOutput(), "domum_ornamentum", exFileHelper);
    }

    protected void registerStatesAndModels() {
        ModBlocks.getInstance().getFramedLights().forEach(this::registerStatesAndModelsFor);
    }

    private void registerStatesAndModelsFor(FramedLightBlock framedLightBlock) {
        ModelBuilder blockModel = ((MateriallyTexturedModelBuilder)((BlockModelBuilder)this.models().withExistingParent("block/framed_light/" + framedLightBlock.getRegistryName().getPath(), this.modLoc("block/framed_light/" + Objects.requireNonNull(framedLightBlock.getRegistryName()).getPath() + "_spec"))).customLoader(MateriallyTexturedModelBuilder::new)).end();
        this.simpleBlock(framedLightBlock, (ModelFile)blockModel);
        ModelBuilderUtils.applyDefaultItemTransforms((ItemModelBuilder)((ItemModelBuilder)this.itemModels().getBuilder(framedLightBlock.getRegistryName().getPath())).parent((ModelFile)blockModel));
    }

    @NotNull
    public String getName() {
        return "Framed Light BlockStates Provider";
    }
}

