/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.datagen.door;

import com.ldtteam.domumornamentum.block.ModBlocks;
import com.ldtteam.domumornamentum.block.types.DoorType;
import com.ldtteam.domumornamentum.block.vanilla.DoorBlock;
import com.ldtteam.domumornamentum.datagen.MateriallyTexturedModelBuilder;
import com.ldtteam.domumornamentum.datagen.utils.ModelBuilderUtils;
import com.ldtteam.domumornamentum.util.Constants;
import java.util.function.Function;
import net.minecraft.core.Direction;
import net.minecraft.data.DataGenerator;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.NotNull;

public class DoorsBlockStateProvider
extends BlockStateProvider {
    public DoorsBlockStateProvider(DataGenerator gen, ExistingFileHelper exFileHelper) {
        super(gen.getPackOutput(), "domum_ornamentum", exFileHelper);
    }

    protected void registerStatesAndModels() {
        this.doorBlock(ModBlocks.getInstance().getDoor(), DoorType::getSerializedName);
    }

    private void doorBlock(DoorBlock block, Function<DoorType, String> baseName) {
        Function<DoorType, ModelFile> bottomLeft = this.createModel(baseName, "bottom_left");
        Function<DoorType, ModelFile> bottomLeftOpen = this.createModel(baseName, "bottom_left_open");
        Function<DoorType, ModelFile> bottomRight = this.createModel(baseName, "bottom_right");
        Function<DoorType, ModelFile> bottomRightOpen = this.createModel(baseName, "bottom_right_open");
        Function<DoorType, ModelFile> topLeft = this.createModel(baseName, "top_left");
        Function<DoorType, ModelFile> topLeftOpen = this.createModel(baseName, "top_left_open");
        Function<DoorType, ModelFile> topRight = this.createModel(baseName, "top_right");
        Function<DoorType, ModelFile> topRightOpen = this.createModel(baseName, "top_right_open");
        this.doorBlock(block, bottomLeft, bottomLeftOpen, bottomRight, bottomRightOpen, topLeft, topLeftOpen, topRight, topRightOpen);
    }

    private Function<DoorType, ModelFile> createModel(Function<DoorType, String> baseName, String stateDescription) {
        return type -> ((MateriallyTexturedModelBuilder)((BlockModelBuilder)this.models().withExistingParent("block/door/door_" + (String)baseName.apply((DoorType)((Object)type)) + "_" + stateDescription, Constants.resLocDO("block/door/door_" + (String)baseName.apply((DoorType)((Object)type)) + "_" + stateDescription + "_spec"))).customLoader(MateriallyTexturedModelBuilder::new)).end();
    }

    public void doorBlock(DoorBlock block, Function<DoorType, ModelFile> bottomLeft, Function<DoorType, ModelFile> bottomLeftOpen, Function<DoorType, ModelFile> bottomRight, Function<DoorType, ModelFile> bottomRightOpen, Function<DoorType, ModelFile> topLeft, Function<DoorType, ModelFile> topLeftOpen, Function<DoorType, ModelFile> topRight, Function<DoorType, ModelFile> topRightOpen) {
        this.getVariantBuilder((Block)block).forAllStatesExcept(state -> {
            int yRot = (int)((Direction)state.getValue((Property)DoorBlock.FACING)).toYRot() + 90;
            boolean right = state.getValue((Property)DoorBlock.HINGE) == DoorHingeSide.RIGHT;
            boolean open = (Boolean)state.getValue((Property)DoorBlock.OPEN);
            boolean lower = state.getValue((Property)DoorBlock.HALF) == DoubleBlockHalf.LOWER;
            DoorType type = (DoorType)((Object)((Object)state.getValue(DoorBlock.TYPE)));
            if (open) {
                yRot += 90;
            }
            if (right && open) {
                yRot += 180;
            }
            yRot %= 360;
            ModelFile model = null;
            if (lower && right && open) {
                model = (ModelFile)bottomRightOpen.apply(type);
            } else if (lower && !right && open) {
                model = (ModelFile)bottomLeftOpen.apply(type);
            }
            if (lower && right && !open) {
                model = (ModelFile)bottomRight.apply(type);
            } else if (lower && !right && !open) {
                model = (ModelFile)bottomLeft.apply(type);
            }
            if (!lower && right && open) {
                model = (ModelFile)topRightOpen.apply(type);
            } else if (!lower && !right && open) {
                model = (ModelFile)topLeftOpen.apply(type);
            }
            if (!lower && right && !open) {
                model = (ModelFile)topRight.apply(type);
            } else if (!(lower || right || open)) {
                model = (ModelFile)topLeft.apply(type);
            }
            return ConfiguredModel.builder().modelFile(model).rotationY(yRot).build();
        }, new Property[]{DoorBlock.POWERED});
        ItemModelBuilder overarchingSpecBuilder = (ItemModelBuilder)this.itemModels().getBuilder(ModBlocks.getInstance().getDoor().getRegistryName().getPath() + "_spec");
        ModelBuilderUtils.applyDoorItemTransforms(overarchingSpecBuilder);
        DoorType[] values = DoorType.values();
        for (int i = 0; i < values.length; ++i) {
            DoorType value = values[i];
            overarchingSpecBuilder.override().predicate(Constants.DOOR_MODEL_OVERRIDE, (float)i).model((ModelFile)this.models().getExistingFile(Constants.resLocDO("item/door/door_" + value.getSerializedName() + "_spec"))).end();
        }
        ItemModelBuilder rootBuilder = (ItemModelBuilder)this.itemModels().getBuilder(ModBlocks.getInstance().getDoor().getRegistryName().getPath());
        ModelBuilderUtils.applyDoorItemTransforms(rootBuilder);
        rootBuilder.customLoader(MateriallyTexturedModelBuilder::new);
        rootBuilder.parent((ModelFile)overarchingSpecBuilder);
    }

    @NotNull
    public String getName() {
        return "Doors BlockStates Provider";
    }
}

